/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.JsonPrism;
import io.avaje.jsonb.generator.Naming;
import io.avaje.jsonb.generator.NamingConvention;
import io.avaje.jsonb.generator.ProcessingContext;
import io.avaje.jsonb.generator.Util;
import java.util.Optional;
import javax.lang.model.element.TypeElement;

final class NamingConventionReader {
    private final String typeProperty;
    private final boolean caseInsensitiveKeys;
    private final NamingConvention namingConvention;

    NamingConventionReader(TypeElement element) {
        Optional<JsonPrism> jsonOptional = JsonPrism.getOptionalOn(element).or(() -> ProcessingContext.importedJson(element));
        if (jsonOptional.isEmpty()) {
            this.typeProperty = null;
            this.namingConvention = null;
            this.caseInsensitiveKeys = false;
            return;
        }
        JsonPrism jsonAnnotation = jsonOptional.get();
        this.namingConvention = NamingConvention.of(NamingConventionReader.naming(jsonAnnotation.naming()));
        this.typeProperty = Util.escapeQuotes(jsonAnnotation.typeProperty());
        this.caseInsensitiveKeys = jsonAnnotation.caseInsensitiveKeys();
    }

    static Naming naming(String entry) {
        int pos = entry.lastIndexOf(46);
        if (pos > -1) {
            entry = entry.substring(pos + 1);
        }
        return Naming.valueOf(entry);
    }

    NamingConvention get() {
        return this.namingConvention != null ? this.namingConvention : NamingConvention.of(Naming.Match);
    }

    String typeProperty() {
        return this.typeProperty;
    }

    boolean isCaseInsensitiveKeys() {
        return this.caseInsensitiveKeys;
    }
}

