/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.APContext;
import io.avaje.jsonb.generator.ImportPrism;
import io.avaje.jsonb.generator.JsonPrism;
import io.avaje.jsonb.generator.SubTypePrism;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

final class ProcessingContext {
    private static final ThreadLocal<Ctx> CTX = new ThreadLocal();

    private ProcessingContext() {
    }

    static void init(ProcessingEnvironment processingEnv) {
        APContext.init(processingEnv);
        CTX.set(new Ctx(processingEnv));
    }

    static boolean useEnhancedSwitch() {
        return APContext.jdkVersion() >= 14;
    }

    static FileObject createMetaInfWriterFor(String interfaceType) throws IOException {
        return APContext.filer().createResource(StandardLocation.CLASS_OUTPUT, "", interfaceType, new Element[0]);
    }

    static void addImportedPrism(ImportPrism prism, Element element) {
        if (!prism.subtypes().isEmpty() && prism.value().size() > 1) {
            APContext.logError(element, "subtypes cannot be used when an import annotation imports more than one class", new Object[0]);
            return;
        }
        Map<String, JsonPrism> json = ProcessingContext.CTX.get().importedJsonMap;
        Map<String, List<SubTypePrism>> subtypes = ProcessingContext.CTX.get().importedSubtypeMap;
        prism.value().forEach(m -> {
            String type = m.toString();
            json.put(type, prism.jsonSettings());
            subtypes.put(type, prism.subtypes());
        });
    }

    static Optional<JsonPrism> importedJson(TypeElement type) {
        return Optional.ofNullable(ProcessingContext.CTX.get().importedJsonMap.get(type.asType().toString()));
    }

    static List<SubTypePrism> importedSubtypes(TypeElement type) {
        return ProcessingContext.CTX.get().importedSubtypeMap.getOrDefault(type.asType().toString(), List.of());
    }

    static void validateModule(String fqn) {
        ModuleElement module = APContext.getProjectModuleElement();
        if (module != null && !ProcessingContext.CTX.get().validated && !module.isUnnamed()) {
            boolean injectPresent = ProcessingContext.CTX.get().injectPresent;
            ProcessingContext.CTX.get().validated = true;
            try (BufferedReader reader = APContext.getModuleInfoReader();){
                AtomicBoolean noInjectPlugin = new AtomicBoolean(injectPresent);
                boolean noProvides = reader.lines().map(s -> {
                    if (injectPresent && (s.contains("io.avaje.jsonb.plugin") || s.contains("io.avaje.nima"))) {
                        noInjectPlugin.set(false);
                    }
                    return s;
                }).noneMatch(s -> s.contains(fqn));
                if (noProvides) {
                    APContext.logError(module, "Missing `provides io.avaje.jsonb.Jsonb.GeneratedComponent with %s;`", fqn);
                }
                if (noInjectPlugin.get()) {
                    APContext.logWarn(module, "`requires io.avaje.jsonb.plugin` must be explicity added or else avaje-inject may fail to detect and wire the default Jsonb instance", fqn);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void clear() {
        CTX.remove();
        APContext.clear();
    }

    private static final class Ctx {
        private final Map<String, JsonPrism> importedJsonMap = new HashMap<String, JsonPrism>();
        private final Map<String, List<SubTypePrism>> importedSubtypeMap = new HashMap<String, List<SubTypePrism>>();
        private final boolean injectPresent;
        private boolean validated;

        Ctx(ProcessingEnvironment env) {
            this.injectPresent = env.getElementUtils().getTypeElement("io.avaje.inject.Component") != null;
        }
    }
}

