/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.APContext;
import io.avaje.jsonb.generator.AdapterName;
import io.avaje.jsonb.generator.Append;
import io.avaje.jsonb.generator.BeanReader;
import io.avaje.jsonb.generator.Util;
import java.io.IOException;
import java.io.Writer;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;

final class SimpleAdapterWriter {
    private final BeanReader beanReader;
    private final String adapterShortName;
    private final String adapterPackage;
    private final String adapterFullName;
    private final int genericParamsCount;
    private final String pkgPrivate;
    private Append writer;

    SimpleAdapterWriter(BeanReader beanReader) {
        this.beanReader = beanReader;
        AdapterName adapterName = new AdapterName(beanReader);
        this.adapterShortName = adapterName.shortName();
        this.adapterPackage = adapterName.adapterPackage();
        this.adapterFullName = adapterName.fullName();
        this.genericParamsCount = beanReader.genericTypeParamsCount();
        this.pkgPrivate = beanReader.isPkgPrivate() ? "" : "public ";
    }

    String fullName() {
        return this.adapterFullName;
    }

    private Writer createFileWriter() throws IOException {
        JavaFileObject jfo = APContext.createSourceFile(this.adapterFullName, new Element[0]);
        return jfo.openWriter();
    }

    boolean hasGenericFactory() {
        return this.genericParamsCount > 0;
    }

    void write() throws IOException {
        this.writer = new Append(this.createFileWriter());
        this.writePackage();
        this.writeImports();
        this.writeClassStart();
        this.writeFactory();
        this.writeFields();
        this.writeConstructor();
        this.writeToFromJson();
        this.writeClassEnd();
        this.writer.close();
    }

    private void writeFactory() {
        if (this.genericParamsCount > 0) {
            String typeName = this.adapterShortName;
            int nestedIndex = this.adapterShortName.indexOf("$");
            if (nestedIndex != -1) {
                typeName = typeName.substring(nestedIndex + 1);
            }
            this.writer.append("  %sstatic final AdapterFactory FACTORY = (type, jsonb) -> {", this.pkgPrivate).eol();
            this.writer.append("    if (Types.isGenericTypeOf(type, %s.class)) {", typeName).eol();
            this.writer.append("      Type[] args = Types.typeArguments(type);").eol();
            this.writer.append("      return new %sJsonAdapter(jsonb", this.adapterShortName);
            for (int i = 0; i < this.genericParamsCount; ++i) {
                this.writer.append(", args[%d]", i);
            }
            this.writer.append(");").eol();
            this.writer.append("    }").eol();
            this.writer.append("    return null;").eol();
            this.writer.append("  };").eol().eol().eol();
        }
    }

    private void writeConstructor() {
        int i;
        this.writer.append("  %s%sJsonAdapter(Jsonb jsonb", this.pkgPrivate, this.adapterShortName);
        for (i = 0; i < this.genericParamsCount; ++i) {
            this.writer.append(", Type param%d", i);
        }
        this.writer.append(") {", this.adapterShortName).eol();
        this.beanReader.writeConstructor(this.writer);
        this.writer.append("  }").eol();
        if (this.genericParamsCount > 0) {
            this.writer.eol();
            this.writer.append("  /**").eol();
            this.writer.append("   * Construct using Object for generic type parameters.").eol();
            this.writer.append("   */").eol();
            this.writer.append("  %s%sJsonAdapter(Jsonb jsonb) {", this.pkgPrivate, this.adapterShortName).eol();
            this.writer.append("    this(jsonb");
            for (i = 0; i < this.genericParamsCount; ++i) {
                this.writer.append(", Object.class");
            }
            this.writer.append(");").eol();
            this.writer.append("  }").eol();
        }
    }

    private void writeToFromJson() {
        this.beanReader.writeViewSupport(this.writer);
        this.beanReader.writeToJson(this.writer);
        this.beanReader.writeFromJson(this.writer);
    }

    private void writeClassEnd() {
        this.writer.append("}").eol();
    }

    private void writeClassStart() {
        if (this.genericParamsCount > 0) {
            this.writer.append("@SuppressWarnings({\"unchecked\", \"rawtypes\"})").eol();
        }
        this.writer.append("@Generated(\"io.avaje.jsonb.generator\")").eol();
        this.writer.append("%sfinal %sclass %sJsonAdapter implements JsonAdapter<%s>", this.pkgPrivate, Util.valhalla(), this.adapterShortName, this.beanReader.shortName());
        if (this.beanReader.supportsViewBuilder()) {
            this.writer.append(", ViewBuilderAware ");
        }
        this.writer.append("{").eol().eol();
    }

    private void writeFields() {
        this.beanReader.writeFields(this.writer);
    }

    private void writeImports() {
        this.beanReader.writeImports(this.writer, this.adapterPackage);
    }

    private void writePackage() {
        this.writer.append("package %s;", this.adapterPackage).eol().eol();
    }
}

