/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.APContext;
import io.avaje.jsonb.generator.CustomAdapterPrism;
import io.avaje.jsonb.generator.TopPackage;
import io.avaje.jsonb.generator.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Predicate;

final class ComponentMetaData {
    private final List<String> allTypes = new ArrayList<String>();
    private final List<String> factoryTypes = new ArrayList<String>();
    private final List<String> withTypes = new ArrayList<String>();
    private String fullName;

    ComponentMetaData() {
    }

    public String toString() {
        return this.allTypes.toString();
    }

    boolean contains(String type) {
        return this.allTypes.contains(type);
    }

    void add(String type) {
        Optional.ofNullable(APContext.typeElement(type)).flatMap(CustomAdapterPrism::getOptionalOn).filter(Predicate.not(CustomAdapterPrism::global)).ifPresentOrElse(p -> this.withTypes.add(type), () -> this.allTypes.add(type));
    }

    void addFactory(String fullName) {
        this.factoryTypes.add(fullName);
    }

    void addWithType(String type) {
        this.withTypes.add(type);
    }

    void setFullName(String fullName) {
        this.fullName = fullName;
    }

    String fullName(boolean pkgPrivate) {
        if (this.fullName == null) {
            ArrayList<String> everyType = new ArrayList<String>(this.allTypes);
            everyType.addAll(this.factoryTypes);
            Object topPackage = TopPackage.of(everyType);
            if (!((String)topPackage).endsWith(".jsonb") && !pkgPrivate) {
                topPackage = (String)topPackage + ".jsonb";
            }
            this.fullName = pkgPrivate ? (String)topPackage + "." + ComponentMetaData.name((String)topPackage) + "JsonComponent" : (String)topPackage + ".GeneratedJsonComponent";
        }
        return this.fullName;
    }

    List<String> all() {
        return this.allTypes;
    }

    List<String> allFactories() {
        return this.factoryTypes;
    }

    List<String> withTypes() {
        return this.withTypes;
    }

    Collection<String> allImports() {
        TreeSet<String> packageImports = new TreeSet<String>();
        for (String adapterFullName : this.allTypes) {
            packageImports.add(adapterFullName);
            String className = Util.baseTypeOfAdapter(adapterFullName);
            int $index = className.indexOf("$");
            packageImports.add($index != -1 ? className.substring(0, $index) : className);
        }
        packageImports.addAll(this.factoryTypes);
        packageImports.addAll(this.withTypes);
        return packageImports;
    }

    boolean isEmpty() {
        return this.allTypes.isEmpty() && this.factoryTypes.isEmpty();
    }

    static String name(String name) {
        if (name == null) {
            return null;
        }
        int pos = name.lastIndexOf(46);
        if (pos > -1) {
            name = name.substring(pos + 1);
        }
        return ComponentMetaData.camelCase(name).replaceFirst("Jsonb", "Generated");
    }

    private static String camelCase(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        boolean upper = true;
        for (char aChar : name.toCharArray()) {
            if (Character.isLetterOrDigit(aChar)) {
                if (upper) {
                    aChar = Character.toUpperCase(aChar);
                    upper = false;
                }
                sb.append(aChar);
                continue;
            }
            if (!ComponentMetaData.toUpperOn(aChar)) continue;
            upper = true;
        }
        return sb.toString();
    }

    private static boolean toUpperOn(char aChar) {
        return aChar == ' ' || aChar == '-' || aChar == '_';
    }
}

