/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.GenericTypeMap;
import io.avaje.jsonb.generator.GenericTypeParser;
import io.avaje.jsonb.generator.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

final class GenericType {
    private static final GenericTypeMap TYPE_MAP = new GenericTypeMap();
    private final String raw;
    private String mainType;
    private final List<GenericType> params = new ArrayList<GenericType>();

    static String trimWildcard(String rawType) {
        if (rawType.endsWith("<?>")) {
            return rawType.substring(0, rawType.length() - 3);
        }
        return rawType;
    }

    GenericType(String raw) {
        this.raw = raw;
    }

    GenericType() {
        this.raw = null;
    }

    static boolean isGeneric(String raw) {
        return raw.contains("<");
    }

    static GenericType parse(String raw) {
        if ((raw = GenericType.trimWildcard(raw)).indexOf(60) == -1) {
            return new GenericType(raw);
        }
        return new GenericTypeParser(raw).parse();
    }

    public String toString() {
        return this.raw != null ? this.raw : this.mainType + "<" + String.valueOf(this.params) + ">";
    }

    void addImports(Set<String> importTypes) {
        String type = this.trimExtends();
        if (GenericType.includeInImports(type)) {
            importTypes.add(type);
        }
        for (GenericType param : this.params) {
            param.addImports(importTypes);
        }
    }

    private static boolean includeInImports(String type) {
        return type != null && !type.startsWith("java.lang.") && type.contains(".");
    }

    String shortType() {
        StringBuilder sb = new StringBuilder();
        this.writeShortType(sb);
        return sb.toString();
    }

    void writeShortType(StringBuilder sb) {
        String main = Util.shortName(this.trimExtends());
        sb.append(main);
        int paramCount = this.params.size();
        if (paramCount > 0) {
            sb.append("<");
            for (int i = 0; i < paramCount; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                this.params.get(i).writeShortType(sb);
            }
            sb.append(">");
        }
    }

    void writeType(String prefix, StringBuilder sb) {
        String main = Util.shortName(this.trimExtends());
        sb.append(prefix).append(main).append(".class");
        int paramCount = this.params.size();
        if (paramCount > 0) {
            for (GenericType param : this.params) {
                param.writeType(",", sb);
            }
        }
    }

    String shortName() {
        StringBuilder sb = new StringBuilder();
        this.shortName(sb);
        return sb.toString().replace("[]", "Array");
    }

    void shortName(StringBuilder sb) {
        sb.append(Util.shortName(this.trimExtends()));
        for (GenericType param : this.params) {
            param.shortName(sb);
        }
    }

    private String trimExtends() {
        String type = this.topType();
        if (type != null && type.startsWith("? extends ")) {
            return type.substring(10);
        }
        return type;
    }

    String topType() {
        return this.mainType != null ? this.mainType : this.raw;
    }

    void setMainType(String mainType) {
        this.mainType = mainType;
    }

    void addParam(GenericType param) {
        this.params.add(param);
    }

    String asTypeDeclaration() {
        String result;
        if (this.params.isEmpty()) {
            return this.asTypeBasic();
        }
        if (this.params.size() == 1 && (result = this.asTypeContainer()) != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.writeType("Types.newParameterizedType(", sb);
        return sb.append(")").toString();
    }

    private String asTypeBasic() {
        String topType = this.topType();
        String adapterType = TYPE_MAP.typeOfRaw(topType);
        if (adapterType != null) {
            return adapterType;
        }
        return Util.shortName(topType) + ".class";
    }

    private String asTypeContainer() {
        GenericType param = this.params.get(0);
        String containerType = this.topType();
        if ("java.util.List".equals(containerType) || "java.util.ArrayList".equals(containerType)) {
            return "Types.listOf(" + Util.shortName(param.topType()) + ".class)";
        }
        if ("java.util.Set".equals(containerType) || "java.util.LinkedHashSet".equals(containerType)) {
            return "Types.setOf(" + Util.shortName(param.topType()) + ".class)";
        }
        if ("java.util.stream.Stream".equals(containerType)) {
            return "Types.streamOf(" + Util.shortName(param.topType()) + ".class)";
        }
        if ("java.util.Optional".equals(containerType)) {
            return "Types.optionalOf(" + Util.shortName(param.topType()) + ".class)";
        }
        return null;
    }

    String firstParamType() {
        return this.params.isEmpty() ? "java.lang.Object" : this.params.get(0).topType();
    }

    String secondParamType() {
        return this.params.size() != 2 ? "java.lang.Object" : this.params.get(1).topType();
    }
}

