/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb;

import io.avaje.jsonb.core.Util;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class Types {
    private Types() {
    }

    public static Type arrayOf(Type elementType) {
        return Util.arrayOf(elementType);
    }

    public static Type listOf(Type elementType) {
        return Types.newParameterizedType(List.class, new Type[]{elementType});
    }

    public static Type setOf(Type elementType) {
        return Types.newParameterizedType(Set.class, new Type[]{elementType});
    }

    public static Type streamOf(Type elementType) {
        return Types.newParameterizedType(Stream.class, new Type[]{elementType});
    }

    public static Type mapOf(Type valueElementType) {
        return Types.newParameterizedType(Map.class, new Type[]{String.class, valueElementType});
    }

    public static ParameterizedType newParameterizedType(Type rawType, Type ... typeArguments) {
        return Util.newParameterizedType(rawType, typeArguments);
    }
}

