/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.core;

import io.avaje.jsonb.JsonAdapter;
import io.avaje.jsonb.JsonReader;
import io.avaje.jsonb.JsonType;
import io.avaje.jsonb.JsonView;
import io.avaje.jsonb.JsonWriter;
import io.avaje.jsonb.Jsonb;
import io.avaje.jsonb.JsonbComponent;
import io.avaje.jsonb.core.CoreAdapterBuilder;
import io.avaje.jsonb.core.DJsonType;
import io.avaje.jsonb.core.ObjectJsonReader;
import io.avaje.jsonb.core.RawAdapter;
import io.avaje.jsonb.core.Util;
import io.avaje.jsonb.core.ViewBuilder;
import io.avaje.jsonb.core.ViewDsl;
import io.avaje.jsonb.spi.AdapterFactory;
import io.avaje.jsonb.spi.BufferedJsonWriter;
import io.avaje.jsonb.spi.BytesJsonWriter;
import io.avaje.jsonb.spi.JsonStreamAdapter;
import io.avaje.jsonb.spi.PropertyNames;
import io.avaje.jsonb.stream.JsonStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;

class DJsonb
implements Jsonb {
    private final CoreAdapterBuilder builder;
    private final JsonStreamAdapter io;
    private final Map<Type, DJsonType<?>> typeCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<ViewKey, JsonView<?>> viewCache = new ConcurrentHashMap();
    private final JsonType<Object> anyType;

    DJsonb(JsonStreamAdapter adapter, List<JsonAdapter.Factory> factories, boolean serializeNulls, boolean serializeEmpty, boolean failOnUnknown, boolean mathAsString) {
        Iterator<AdapterFactory> iterator;
        this.builder = new CoreAdapterBuilder(this, factories, mathAsString);
        this.io = adapter != null ? adapter : ((iterator = ServiceLoader.load(AdapterFactory.class).iterator()).hasNext() ? iterator.next().create(serializeNulls, serializeEmpty, failOnUnknown) : new JsonStream(serializeNulls, serializeEmpty, failOnUnknown));
        this.anyType = this.type(Object.class);
    }

    @Override
    public String toJson(Object any) {
        return this.anyType.toJson(any);
    }

    @Override
    public String toJsonPretty(Object any) {
        return this.anyType.toJsonPretty(any);
    }

    @Override
    public byte[] toJsonBytes(Object any) {
        return this.anyType.toJsonBytes(any);
    }

    @Override
    public void toJson(Object any, Writer writer) {
        this.anyType.toJson(any, writer);
    }

    @Override
    public void toJson(Object any, OutputStream outputStream) {
        this.anyType.toJson(any, outputStream);
    }

    @Override
    public void toJson(Object any, JsonWriter jsonWriter) {
        this.anyType.toJson(any, jsonWriter);
    }

    @Override
    public PropertyNames properties(String ... names) {
        return this.io.properties(names);
    }

    BufferedJsonWriter bufferedWriter() {
        return this.io.bufferedWriter();
    }

    BytesJsonWriter bufferedWriterAsBytes() {
        return this.io.bufferedWriterAsBytes();
    }

    @Override
    public JsonWriter writer(Writer writer) {
        return this.io.writer(writer);
    }

    @Override
    public JsonWriter writer(OutputStream outputStream) {
        return this.io.writer(outputStream);
    }

    @Override
    public JsonReader reader(Reader reader) {
        return this.io.reader(reader);
    }

    @Override
    public JsonReader reader(InputStream inputStream) {
        return this.io.reader(inputStream);
    }

    @Override
    public JsonReader reader(String json) {
        return this.io.reader(json);
    }

    @Override
    public JsonReader reader(byte[] json) {
        return this.io.reader(json);
    }

    @Override
    public <T> JsonType<T> type(Class<T> cls) {
        return this.typeWithCache(cls);
    }

    @Override
    public <T> JsonType<T> type(Type type) {
        return this.typeWithCache(type);
    }

    @Override
    public <T> JsonType<T> typeOf(Object first) {
        Objects.requireNonNull(first);
        return this.type((Type)first.getClass());
    }

    private <T> JsonType<T> typeWithCache(Type type) {
        return this.typeCache.computeIfAbsent(type, _type -> new DJsonType(this, (Type)_type, this.adapter((Type)_type)));
    }

    @Override
    public <T> JsonAdapter<T> adapter(Class<T> cls) {
        Type cacheKey = Util.canonicalizeClass(Objects.requireNonNull(cls));
        JsonAdapter result = this.builder.get(cacheKey);
        if (result != null) {
            return result;
        }
        return this.builder.build(cacheKey);
    }

    @Override
    public <T> JsonAdapter<T> adapter(Type type) {
        Type cacheKey = type = Util.removeSubtypeWildcard(Util.canonicalize(Objects.requireNonNull(type)));
        JsonAdapter result = this.builder.get(cacheKey);
        if (result != null) {
            return result;
        }
        return this.builder.build(type, cacheKey);
    }

    @Override
    public JsonAdapter<String> rawAdapter() {
        return RawAdapter.STR;
    }

    JsonReader objectReader(Object value) {
        return new ObjectJsonReader(value);
    }

    <T> JsonView<T> buildView(String dsl, JsonAdapter<T> adapter, Type type) {
        ViewKey key = new ViewKey(dsl, type);
        return this.viewCache.computeIfAbsent(key, o -> {
            try {
                ViewBuilder viewBuilder = new ViewBuilder(ViewDsl.parse(dsl));
                adapter.viewBuild().build(viewBuilder);
                return viewBuilder.build(this);
            }
            catch (Throwable e) {
                throw new IllegalStateException(e);
            }
        });
    }

    private static boolean simpleMatch(Type type, Type targetType) {
        return Util.typesMatch(type, targetType);
    }

    static final class ViewKey {
        private final String dsl;
        private final Type type;

        ViewKey(String dsl, Type type) {
            this.dsl = dsl;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ViewKey viewKey = (ViewKey)o;
            return this.dsl.equals(viewKey.dsl) && this.type.equals(viewKey.type);
        }

        public int hashCode() {
            return Objects.hash(this.dsl, this.type);
        }
    }

    static final class DBuilder
    implements Jsonb.Builder {
        private final List<JsonAdapter.Factory> factories = new ArrayList<JsonAdapter.Factory>();
        private boolean failOnUnknown;
        private boolean mathTypesAsString;
        private boolean serializeNulls;
        private boolean serializeEmpty;
        private JsonStreamAdapter adapter;

        DBuilder() {
        }

        @Override
        public Jsonb.Builder serializeNulls(boolean serializeNulls) {
            this.serializeNulls = serializeNulls;
            return this;
        }

        @Override
        public Jsonb.Builder serializeEmpty(boolean serializeEmpty) {
            this.serializeEmpty = serializeEmpty;
            return this;
        }

        @Override
        public Jsonb.Builder failOnUnknown(boolean failOnUnknown) {
            this.failOnUnknown = failOnUnknown;
            return this;
        }

        @Override
        public Jsonb.Builder mathTypesAsString(boolean mathTypesAsString) {
            this.mathTypesAsString = mathTypesAsString;
            return this;
        }

        @Override
        public Jsonb.Builder adapter(JsonStreamAdapter streamAdapter) {
            this.adapter = streamAdapter;
            return this;
        }

        @Override
        public Jsonb.Builder add(Type type, Jsonb.AdapterBuilder builder) {
            return this.add(DBuilder.newAdapterFactory(type, builder));
        }

        @Override
        public <T> Jsonb.Builder add(Type type, JsonAdapter<T> jsonAdapter) {
            return this.add(DBuilder.newAdapterFactory(type, jsonAdapter));
        }

        @Override
        public Jsonb.Builder add(JsonbComponent component) {
            component.register(this);
            return this;
        }

        @Override
        public Jsonb.Builder add(JsonAdapter.Factory factory) {
            this.factories.add(factory);
            return this;
        }

        private void registerComponents() {
            for (JsonbComponent jsonbComponent : ServiceLoader.load(JsonbComponent.class)) {
                jsonbComponent.register(this);
            }
            for (Jsonb.GeneratedComponent generatedComponent : ServiceLoader.load(Jsonb.GeneratedComponent.class)) {
                generatedComponent.register(this);
            }
        }

        @Override
        public DJsonb build() {
            this.registerComponents();
            return new DJsonb(this.adapter, this.factories, this.serializeNulls, this.serializeEmpty, this.failOnUnknown, this.mathTypesAsString);
        }

        static <T> JsonAdapter.Factory newAdapterFactory(Type type, JsonAdapter<T> jsonAdapter) {
            Objects.requireNonNull(type);
            Objects.requireNonNull(jsonAdapter);
            return (targetType, jsonb) -> DJsonb.simpleMatch(type, targetType) ? jsonAdapter : null;
        }

        static <T> JsonAdapter.Factory newAdapterFactory(Type type, Jsonb.AdapterBuilder builder) {
            Objects.requireNonNull(type);
            Objects.requireNonNull(builder);
            return (targetType, jsonb) -> DJsonb.simpleMatch(type, targetType) ? builder.build(jsonb).nullSafe() : null;
        }
    }
}

