/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.stream;

import io.avaje.jsonb.spi.PropertyNames;
import io.avaje.jsonb.stream.Escape;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class JsonNames
implements PropertyNames {
    private final byte[][] nameArray;
    private final Map<Long, String> nameHash;

    JsonNames(byte[][] nameArray, Map<Long, String> nameHash) {
        this.nameArray = nameArray;
        this.nameHash = nameHash;
    }

    public static JsonNames of(String ... names) {
        boolean hashingClash = false;
        HashMap<Long, String> nameHash = new HashMap<Long, String>();
        byte[][] nameArray = new byte[names.length][];
        for (int i = 0; i < names.length; ++i) {
            nameArray[i] = Escape.quoteEscape(names[i]);
            long hash = Escape.nameHash(names[i]);
            if (nameHash.put(hash, names[i]) == null) continue;
            hashingClash = true;
        }
        return new JsonNames(nameArray, hashingClash ? Collections.emptyMap() : nameHash);
    }

    byte[] key(int namePos) {
        return this.nameArray[namePos];
    }

    String lookup(long hash) {
        return this.nameHash.get(hash);
    }
}

