/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.stream;

import io.avaje.jsonb.stream.JGenerator;
import io.avaje.jsonb.stream.JParser;
import io.avaje.jsonb.stream.JsonGenerator;
import io.avaje.jsonb.stream.JsonParser;
import java.io.InputStream;
import java.io.OutputStream;

final class Recycle {
    private static boolean jvmRecycle;
    private static ThreadLocal<JParser> read;
    private static ThreadLocal<JGenerator> managed;

    private Recycle() {
    }

    static JsonGenerator generator(OutputStream target) {
        return (jvmRecycle ? Recycle.getGenerator() : managed.get()).prepare(target);
    }

    static JsonGenerator generator() {
        return (jvmRecycle ? Recycle.getGenerator() : managed.get()).prepare(null);
    }

    static JsonParser parser(byte[] bytes) {
        return (jvmRecycle ? Recycle.getParser() : read.get()).process(bytes, bytes.length);
    }

    static JsonParser parser(InputStream in) {
        return (jvmRecycle ? Recycle.getParser() : read.get()).process(in);
    }

    static JGenerator getGenerator() {
        return new JGenerator(4096);
    }

    static JParser getParser() {
        char[] ch = new char[4096];
        byte[] by = new byte[4096];
        return new JParser(ch, by, 0, JParser.ErrorInfo.MINIMAL, JParser.DoublePrecision.DEFAULT, JParser.UnknownNumberParsing.BIGDECIMAL, 100, 50000);
    }

    static {
        if (Float.parseFloat(System.getProperty("java.specification.version")) >= 19.0f && !Boolean.getBoolean("jsonb.useTLBuffers")) {
            jvmRecycle = true;
        } else {
            managed = ThreadLocal.withInitial(Recycle::getGenerator);
            read = ThreadLocal.withInitial(Recycle::getParser);
        }
    }
}

