/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.stream;

import io.avaje.jsonb.JsonReader;
import io.avaje.jsonb.JsonWriter;
import io.avaje.jsonb.spi.BufferedJsonWriter;
import io.avaje.jsonb.spi.BytesJsonWriter;
import io.avaje.jsonb.spi.DelegateJsonWriter;
import io.avaje.jsonb.spi.JsonStreamAdapter;
import io.avaje.jsonb.spi.PropertyNames;
import io.avaje.jsonb.stream.BufferRecycleStrategy;
import io.avaje.jsonb.stream.BufferRecycler;
import io.avaje.jsonb.stream.JsonGenerator;
import io.avaje.jsonb.stream.JsonNames;
import io.avaje.jsonb.stream.JsonOutput;
import io.avaje.jsonb.stream.JsonParser;
import io.avaje.jsonb.stream.JsonReadAdapter;
import io.avaje.jsonb.stream.JsonWriteAdapter;
import io.avaje.jsonb.stream.ReaderInputStream;
import io.avaje.jsonb.stream.WriterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public final class JsonStream
implements JsonStreamAdapter {
    private final boolean serializeNulls;
    private final boolean serializeEmpty;
    private final boolean failOnUnknown;
    private final BufferRecycler recycle;

    public JsonStream() {
        this(false, false, false);
    }

    public JsonStream(boolean serializeNulls, boolean serializeEmpty, boolean failOnUnknown) {
        this(serializeNulls, serializeEmpty, failOnUnknown, BufferRecycleStrategy.HYBRID_POOL);
    }

    public JsonStream(boolean serializeNulls, boolean serializeEmpty, boolean failOnUnknown, BufferRecycleStrategy recycle) {
        this.serializeNulls = serializeNulls;
        this.serializeEmpty = serializeEmpty;
        this.failOnUnknown = failOnUnknown;
        this.recycle = recycle.recycler();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public PropertyNames properties(String ... names) {
        return JsonNames.of(names);
    }

    @Override
    public JsonReader reader(String json) {
        return this.reader(json.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public JsonReader reader(byte[] json) {
        JsonParser parser = this.recycle.parser(json);
        return new JsonReadAdapter(parser, this.recycle, this.failOnUnknown);
    }

    @Override
    public JsonReader reader(Reader reader) {
        return this.reader(new ReaderInputStream(reader, StandardCharsets.UTF_8));
    }

    @Override
    public JsonReader reader(InputStream inputStream) {
        JsonParser parser = this.recycle.parser(inputStream);
        return new JsonReadAdapter(parser, this.recycle, this.failOnUnknown);
    }

    @Override
    public JsonWriter writer(Writer writer) {
        return this.writer(new WriterOutputStream(writer, StandardCharsets.UTF_8));
    }

    @Override
    public JsonWriter writer(OutputStream outputStream) {
        return this.writer(JsonOutput.of(outputStream));
    }

    @Override
    public JsonWriter writer(JsonOutput output) {
        return this.wrap(this.gen(output));
    }

    @Override
    public BufferedJsonWriter bufferedWriter() {
        JsonGenerator generator = this.recycle.generator();
        return new BufferedWriter(this.wrap(generator), generator);
    }

    @Override
    public BytesJsonWriter bufferedWriterAsBytes() {
        JsonGenerator generator = this.recycle.generator();
        return new BytesWriter(this.wrap(generator), generator);
    }

    private JsonGenerator gen(JsonOutput output) {
        return this.recycle.generator(output);
    }

    private JsonWriteAdapter wrap(JsonGenerator generator) {
        return new JsonWriteAdapter(generator, this.recycle, this.serializeNulls, this.serializeEmpty);
    }

    public static final class Builder {
        private BufferRecycleStrategy strategy = BufferRecycleStrategy.HYBRID_POOL;
        private boolean serializeNulls;
        private boolean serializeEmpty;
        private boolean failOnUnknown;

        public Builder serializeNulls(boolean serializeNulls) {
            this.serializeNulls = serializeNulls;
            return this;
        }

        public Builder serializeEmpty(boolean serializeEmpty) {
            this.serializeEmpty = serializeEmpty;
            return this;
        }

        public Builder failOnUnknown(boolean failOnUnknown) {
            this.failOnUnknown = failOnUnknown;
            return this;
        }

        Builder bufferRecycling(BufferRecycleStrategy strategy) {
            this.strategy = strategy;
            return this;
        }

        public JsonStream build() {
            return new JsonStream(this.serializeNulls, this.serializeEmpty, this.failOnUnknown, this.strategy);
        }
    }

    private static class BufferedWriter
    extends DelegateJsonWriter
    implements BufferedJsonWriter {
        private final JsonGenerator generator;

        BufferedWriter(JsonWriteAdapter delegate, JsonGenerator generator) {
            super(delegate);
            this.generator = generator;
        }

        @Override
        public String result() {
            return this.generator.toString();
        }
    }

    private static class BytesWriter
    extends DelegateJsonWriter
    implements BytesJsonWriter {
        private final JsonGenerator generator;

        public BytesWriter(JsonWriteAdapter delegate, JsonGenerator generator) {
            super(delegate);
            this.generator = generator;
        }

        @Override
        public byte[] result() {
            return this.generator.toByteArray();
        }
    }
}

