/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb;

import io.avaje.jsonb.JsonAdapter;
import io.avaje.jsonb.JsonReader;
import io.avaje.jsonb.JsonWriter;
import io.avaje.jsonb.spi.ViewBuilderAware;

final class NullSafeAdapter<T>
implements JsonAdapter<T> {
    private final JsonAdapter<T> delegate;

    NullSafeAdapter(JsonAdapter<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void toJson(JsonWriter writer, T value) {
        if (value == null) {
            writer.nullValue();
        } else {
            this.delegate.toJson(writer, value);
        }
    }

    @Override
    public T fromJson(JsonReader reader) {
        if (reader.isNullValue()) {
            return null;
        }
        return this.delegate.fromJson(reader);
    }

    @Override
    public boolean isViewBuilderAware() {
        return this.delegate.isViewBuilderAware();
    }

    @Override
    public ViewBuilderAware viewBuild() {
        return this.delegate.viewBuild();
    }

    public String toString() {
        return String.valueOf(this.delegate) + ".nullSafe()";
    }
}

