/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.core;

import io.avaje.jsonb.JsonAdapter;
import io.avaje.jsonb.JsonReader;
import io.avaje.jsonb.JsonWriter;
import io.avaje.jsonb.core.DJsonClosable;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

final class StreamAdapter<T>
implements JsonAdapter<Stream<T>>,
DJsonClosable<Stream<T>> {
    private final JsonAdapter<T> elementAdapter;

    StreamAdapter(JsonAdapter<T> elementAdapter) {
        this.elementAdapter = elementAdapter;
    }

    @Override
    public void toJson(JsonWriter writer, Stream<T> value) {
        writer.beginArray();
        value.forEach(bean -> this.elementAdapter.toJson(writer, bean));
        writer.endArray();
    }

    @Override
    public Stream<T> fromJson(JsonReader reader) {
        Iter<T> iterator = new Iter<T>(this.elementAdapter, reader, false);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
    }

    @Override
    public Stream<T> fromJsonWithClose(JsonReader reader) {
        Iter<T> iterator = new Iter<T>(this.elementAdapter, reader, true);
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).onClose(reader::close);
    }

    static class Iter<T>
    implements Iterator<T> {
        private final JsonAdapter<T> elementAdapter;
        private final JsonReader reader;
        private final boolean closeReader;

        Iter(JsonAdapter<T> elementAdapter, JsonReader reader, boolean closeReader) {
            this.elementAdapter = elementAdapter;
            this.reader = reader;
            this.closeReader = closeReader;
            reader.beginStream();
        }

        @Override
        public boolean hasNext() {
            boolean result = this.reader.hasNextStreamElement();
            if (!result) {
                this.endStream();
            }
            return result;
        }

        @Override
        public T next() {
            return this.elementAdapter.fromJson(this.reader);
        }

        private void endStream() {
            this.reader.endStream();
            if (this.closeReader) {
                this.reader.close();
            }
        }
    }
}

