/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.stream;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;

final class Escape {
    private static final byte QUOTE = 34;
    private static final byte ESCAPE = 92;

    Escape() {
    }

    static byte[] quoteEscape(CharSequence value) {
        int len = value.length();
        ByteArrayOutputStream ba = new ByteArrayOutputStream(len << 2);
        ba.write(34);
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c <= '\u001f' || c == '\"' || c == '\\' || c >= '~') {
                Escape.writeQuotedString(value, i, len, ba);
                ba.write(34);
                return ba.toByteArray();
            }
            ba.write((byte)c);
        }
        ba.write(34);
        return ba.toByteArray();
    }

    private static void writeQuotedString(CharSequence str, int i, int len, ByteArrayOutputStream ba) {
        while (i < len) {
            char c = str.charAt(i);
            if (c == '\"') {
                ba.write(92);
                ba.write(34);
            } else if (c == '\\') {
                ba.write(92);
                ba.write(92);
            } else if (c < ' ') {
                block0 : switch (c) {
                    case '\b': {
                        ba.write(92);
                        ba.write(98);
                        break;
                    }
                    case '\t': {
                        ba.write(92);
                        ba.write(116);
                        break;
                    }
                    case '\n': {
                        ba.write(92);
                        ba.write(110);
                        break;
                    }
                    case '\f': {
                        ba.write(92);
                        ba.write(102);
                        break;
                    }
                    case '\r': {
                        ba.write(92);
                        ba.write(114);
                        break;
                    }
                    default: {
                        ba.write(92);
                        ba.write(117);
                        ba.write(48);
                        ba.write(48);
                        switch (c) {
                            case '\u0000': {
                                ba.write(48);
                                ba.write(48);
                                break block0;
                            }
                            case '\u0001': {
                                ba.write(48);
                                ba.write(49);
                                break block0;
                            }
                            case '\u0002': {
                                ba.write(48);
                                ba.write(50);
                                break block0;
                            }
                            case '\u0003': {
                                ba.write(48);
                                ba.write(51);
                                break block0;
                            }
                            case '\u0004': {
                                ba.write(48);
                                ba.write(52);
                                break block0;
                            }
                            case '\u0005': {
                                ba.write(48);
                                ba.write(53);
                                break block0;
                            }
                            case '\u0006': {
                                ba.write(48);
                                ba.write(54);
                                break block0;
                            }
                            case '\u0007': {
                                ba.write(48);
                                ba.write(55);
                                break block0;
                            }
                            case '\u000b': {
                                ba.write(48);
                                ba.write(66);
                                break block0;
                            }
                            case '\u000e': {
                                ba.write(48);
                                ba.write(69);
                                break block0;
                            }
                            case '\u000f': {
                                ba.write(48);
                                ba.write(70);
                                break block0;
                            }
                            case '\u0010': {
                                ba.write(49);
                                ba.write(48);
                                break block0;
                            }
                            case '\u0011': {
                                ba.write(49);
                                ba.write(49);
                                break block0;
                            }
                            case '\u0012': {
                                ba.write(49);
                                ba.write(50);
                                break block0;
                            }
                            case '\u0013': {
                                ba.write(49);
                                ba.write(51);
                                break block0;
                            }
                            case '\u0014': {
                                ba.write(49);
                                ba.write(52);
                                break block0;
                            }
                            case '\u0015': {
                                ba.write(49);
                                ba.write(53);
                                break block0;
                            }
                            case '\u0016': {
                                ba.write(49);
                                ba.write(54);
                                break block0;
                            }
                            case '\u0017': {
                                ba.write(49);
                                ba.write(55);
                                break block0;
                            }
                            case '\u0018': {
                                ba.write(49);
                                ba.write(56);
                                break block0;
                            }
                            case '\u0019': {
                                ba.write(49);
                                ba.write(57);
                                break block0;
                            }
                            case '\u001a': {
                                ba.write(49);
                                ba.write(65);
                                break block0;
                            }
                            case '\u001b': {
                                ba.write(49);
                                ba.write(66);
                                break block0;
                            }
                            case '\u001c': {
                                ba.write(49);
                                ba.write(67);
                                break block0;
                            }
                            case '\u001d': {
                                ba.write(49);
                                ba.write(68);
                                break block0;
                            }
                            case '\u001e': {
                                ba.write(49);
                                ba.write(69);
                                break block0;
                            }
                        }
                        ba.write(49);
                        ba.write(70);
                        break;
                    }
                }
            } else if (c < '\u007f') {
                ba.write((byte)c);
            } else {
                int cp = Character.codePointAt(str, i);
                if (Character.isSupplementaryCodePoint(cp)) {
                    ++i;
                }
                if (cp == 127) {
                    ba.write((byte)cp);
                } else if (cp <= 2047) {
                    ba.write((byte)(0xC0 | cp >> 6 & 0x1F));
                    ba.write((byte)(0x80 | cp & 0x3F));
                } else if (cp < 55296 || cp > 57343 && cp <= 65535) {
                    ba.write((byte)(0xE0 | cp >> 12 & 0xF));
                    ba.write((byte)(0x80 | cp >> 6 & 0x3F));
                    ba.write((byte)(0x80 | cp & 0x3F));
                } else if (cp >= 65536 && cp <= 0x10FFFF) {
                    ba.write((byte)(0xF0 | cp >> 18 & 7));
                    ba.write((byte)(0x80 | cp >> 12 & 0x3F));
                    ba.write((byte)(0x80 | cp >> 6 & 0x3F));
                    ba.write((byte)(0x80 | cp & 0x3F));
                } else {
                    throw new IllegalArgumentException("Unknown unicode codepoint in string! " + Integer.toHexString(cp));
                }
            }
            ++i;
        }
    }

    static long nameHash(String name) {
        byte[] bytes;
        long hash = -2128831035L;
        for (byte b : bytes = name.getBytes(StandardCharsets.UTF_8)) {
            hash ^= (long)b;
            hash *= 16777619L;
        }
        return hash;
    }
}

