/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.stream;

import io.avaje.jsonb.JsonDataException;
import io.avaje.jsonb.JsonEofException;
import io.avaje.jsonb.JsonIoException;
import io.avaje.jsonb.stream.Base64;
import io.avaje.jsonb.stream.JsonNames;
import io.avaje.jsonb.stream.JsonParser;
import io.avaje.jsonb.stream.NumberParser;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Formatter;

final class JParser
implements JsonParser {
    private static final boolean[] WHITESPACE = new boolean[256];
    private static final Charset utf8 = StandardCharsets.UTF_8;
    private int tokenStart;
    private int nameEnd;
    private int currentIndex = 0;
    private long currentPosition = 0L;
    private byte last = (byte)32;
    private int length;
    private final char[] tmp;
    byte[] buffer;
    char[] chars;
    private ByteArrayOutputStream readRawBuffer;
    private int readRawStartPosition;
    private InputStream stream;
    private int readLimit;
    private int bufferLenWithExtraSpace;
    private final byte[] originalBuffer;
    private final int originalBufferLenWithExtraSpace;
    private final Deque<JsonNames> nameStack = new ArrayDeque<JsonNames>();
    private JsonNames currentNames;
    final ErrorInfo errorInfo;
    final DoublePrecision doublePrecision;
    final int doubleLengthLimit;
    final UnknownNumberParsing unknownNumbers;
    final int maxNumberDigits;
    private final int maxStringBuffer;
    private static final EOFException eof;
    private int lastNameLen;
    private final StringBuilder error = new StringBuilder(0);
    private final Formatter errorFormatter = new Formatter(this.error);

    JParser(char[] tmp, byte[] buffer, int length, ErrorInfo errorInfo, DoublePrecision doublePrecision, UnknownNumberParsing unknownNumbers, int maxNumberDigits, int maxStringBuffer) {
        this.tmp = tmp;
        this.buffer = buffer;
        this.length = length;
        this.bufferLenWithExtraSpace = buffer.length - 38;
        this.chars = tmp;
        this.errorInfo = errorInfo;
        this.doublePrecision = doublePrecision;
        this.unknownNumbers = unknownNumbers;
        this.maxNumberDigits = maxNumberDigits;
        this.maxStringBuffer = maxStringBuffer;
        this.doubleLengthLimit = 15 + doublePrecision.level;
        this.originalBuffer = buffer;
        this.originalBufferLenWithExtraSpace = this.bufferLenWithExtraSpace;
    }

    @Override
    public void close() {
        this.buffer = this.originalBuffer;
        this.bufferLenWithExtraSpace = this.originalBufferLenWithExtraSpace;
        this.last = (byte)32;
        this.currentIndex = 0;
        this.length = 0;
        this.readLimit = 0;
        this.nameStack.clear();
        this.stream = null;
    }

    public JParser process(InputStream newStream) {
        this.nameStack.clear();
        this.currentPosition = 0L;
        this.currentIndex = 0;
        this.stream = newStream;
        if (newStream != null) {
            this.readLimit = Math.min(this.length, this.bufferLenWithExtraSpace);
            int available = JParser.readFully(this.buffer, newStream, 0);
            this.readLimit = Math.min(available, this.bufferLenWithExtraSpace);
            this.length = available;
        }
        return this;
    }

    public JParser process(byte[] newBuffer, int newLength) {
        if (newBuffer != null) {
            this.buffer = newBuffer;
            this.bufferLenWithExtraSpace = this.buffer.length - 38;
        }
        if (newLength > this.buffer.length) {
            throw new IllegalArgumentException("length can't be longer than buffer.length");
        }
        this.nameStack.clear();
        this.currentIndex = 0;
        this.length = newLength;
        this.stream = null;
        this.readLimit = newLength;
        return this;
    }

    @Override
    public void names(JsonNames names) {
        if (this.currentNames != null) {
            this.nameStack.push(this.currentNames);
        }
        this.currentNames = names;
    }

    int length() {
        return this.length;
    }

    public String toString() {
        return new String(this.buffer, 0, this.length, utf8);
    }

    private static int readFully(byte[] buffer, InputStream stream, int offset) {
        try {
            int position;
            int read;
            for (position = offset; position < buffer.length && (read = stream.read(buffer, position, buffer.length - position)) != -1; position += read) {
            }
            return position;
        }
        catch (IOException e) {
            throw new JsonIoException(e);
        }
    }

    private byte read() {
        if (this.stream != null && this.currentIndex > this.readLimit) {
            this.prepareNextBlock();
        }
        if (this.currentIndex >= this.length) {
            throw new JsonEofException("Unexpected end of JSON input");
        }
        this.last = this.buffer[this.currentIndex++];
        return this.last;
    }

    private int prepareNextBlock() {
        int len = this.length - this.currentIndex;
        if (this.readRawBuffer != null) {
            this.readRawBuffer.write(this.buffer, this.readRawStartPosition, this.currentIndex - this.readRawStartPosition);
            this.readRawStartPosition = 0;
            if (this.readRawBuffer.size() > this.maxStringBuffer) {
                throw this.newParseErrorWith("Maximum buffer limit exceeded for raw content", this.maxStringBuffer);
            }
        }
        System.arraycopy(this.buffer, this.currentIndex, this.buffer, 0, len);
        int available = JParser.readFully(this.buffer, this.stream, len);
        this.currentPosition += (long)this.currentIndex;
        if (available == len) {
            this.length = this.readLimit = this.length - this.currentIndex;
        } else {
            this.readLimit = Math.min(available, this.bufferLenWithExtraSpace);
            this.length = available;
        }
        this.currentIndex = 0;
        return available;
    }

    boolean isEndOfStream() {
        if (this.stream == null) {
            return this.length == this.currentIndex;
        }
        if (this.length != this.currentIndex) {
            return false;
        }
        return this.prepareNextBlock() == 0;
    }

    @Override
    public byte currentToken() {
        return this.last;
    }

    @Override
    public String location() {
        StringBuilder error = new StringBuilder(60);
        this.positionDescription(0, error);
        return error.toString();
    }

    private void positionDescription(int offset, StringBuilder error) {
        int maxLen2;
        error.append("at position: ").append(this.positionInStream(offset));
        if (this.currentIndex > offset) {
            try {
                maxLen2 = Math.min(this.currentIndex - offset, 20);
                String prefix = new String(this.buffer, this.currentIndex - offset - maxLen2, maxLen2, utf8);
                error.append(", following: `");
                error.append(prefix);
                error.append('`');
            }
            catch (Exception maxLen2) {
                // empty catch block
            }
        }
        if (this.currentIndex - offset < this.readLimit) {
            try {
                maxLen2 = Math.min(this.readLimit - this.currentIndex + offset, 20);
                String suffix = new String(this.buffer, this.currentIndex - offset, maxLen2, utf8);
                error.append(", before: `");
                error.append(suffix);
                error.append('`');
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    int getCurrentIndex() {
        return this.currentIndex;
    }

    int scanNumber() {
        this.tokenStart = this.currentIndex - 1;
        int i = 1;
        int ci = this.currentIndex;
        byte bb = this.last;
        while (ci < this.length && (bb = this.buffer[ci++]) != 44 && bb != 125 && bb != 93) {
            ++i;
        }
        this.currentIndex += i - 1;
        this.last = bb;
        return this.tokenStart;
    }

    char[] prepareBuffer(int start, int len) {
        if (len > this.maxNumberDigits) {
            throw this.newParseErrorWith("Too many digits detected in number", len, "Too many digits detected in number", len, "");
        }
        while (this.chars.length < len) {
            this.chars = Arrays.copyOf(this.chars, this.chars.length * 2);
        }
        char[] _tmp = this.chars;
        byte[] _buf = this.buffer;
        for (int i = 0; i < len; ++i) {
            _tmp[i] = (char)_buf[start + i];
        }
        return _tmp;
    }

    boolean allWhitespace(int start, int end) {
        byte[] _buf = this.buffer;
        for (int i = start; i < end; ++i) {
            if (WHITESPACE[_buf[i] + 128]) continue;
            return false;
        }
        return true;
    }

    int findNonWhitespace(int end) {
        byte[] _buf = this.buffer;
        for (int i = end - 1; i > 0; --i) {
            if (WHITESPACE[_buf[i] + 128]) continue;
            return i + 1;
        }
        return 0;
    }

    char[] readSimpleQuote() {
        if (this.last != 34) {
            throw this.newParseError("Expecting '\"' for string start");
        }
        int ci = this.tokenStart = this.currentIndex;
        try {
            byte bb;
            for (int i = 0; i < this.tmp.length && (bb = this.buffer[ci++]) != 34; ++i) {
                this.tmp[i] = (char)bb;
            }
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            throw this.newParseErrorAt("JSON string was not closed with a double quote", 0);
        }
        if (ci > this.length) {
            throw this.newParseErrorAt("JSON string was not closed with a double quote", 0);
        }
        this.currentIndex = ci;
        return this.tmp;
    }

    @Override
    public int readInt() {
        return NumberParser.deserializeInt(this);
    }

    @Override
    public long readLong() {
        return NumberParser.deserializeLong(this);
    }

    @Override
    public short readShort() {
        return NumberParser.deserializeShort(this);
    }

    @Override
    public double readDouble() {
        return NumberParser.deserializeDouble(this);
    }

    @Override
    public BigDecimal readDecimal() {
        return NumberParser.deserializeDecimal(this);
    }

    @Override
    public BigInteger readBigInteger() {
        return NumberParser.deserializeBigInt(this);
    }

    @Override
    public boolean readBoolean() {
        if (this.wasTrue()) {
            return true;
        }
        if (this.wasFalse()) {
            return false;
        }
        throw this.newParseErrorAt("Found invalid boolean value", 0);
    }

    @Override
    public String readString() {
        int len = this.parseString();
        return new String(this.chars, 0, len);
    }

    int parseString() {
        int startIndex = this.currentIndex;
        if (this.last != 34) {
            throw this.newParseError("Expecting '\"' for string start");
        }
        if (this.currentIndex == this.length) {
            throw this.newParseErrorAt("Premature end of JSON string", 0);
        }
        int ci = this.currentIndex;
        char[] _tmp = this.chars;
        int remaining = this.length - this.currentIndex;
        int _tmpLen = Math.min(_tmp.length, remaining);
        int i = 0;
        while (i < _tmpLen) {
            byte bb;
            if ((bb = this.buffer[ci++]) == 34) {
                this.currentIndex = ci;
                return i;
            }
            if ((bb ^ 0x5C) < 1) break;
            _tmp[i++] = (char)bb;
        }
        if (i == _tmp.length) {
            int newSize = this.chars.length * 2;
            if (newSize > this.maxStringBuffer) {
                throw this.newParseErrorWith("Maximum string buffer limit exceeded", this.maxStringBuffer);
            }
            _tmp = this.chars = Arrays.copyOf(this.chars, newSize);
        }
        _tmpLen = _tmp.length;
        this.currentIndex = ci;
        int soFar = --this.currentIndex - startIndex;
        while (!this.isEndOfStream()) {
            int bc;
            block33: {
                int newSize;
                block32: {
                    bc = this.read();
                    if (bc == 34) {
                        return soFar;
                    }
                    if (bc != 92) break block32;
                    if (soFar >= _tmpLen - 6) {
                        newSize = this.chars.length * 2;
                        if (newSize > this.maxStringBuffer) {
                            throw this.newParseErrorWith("Maximum string buffer limit exceeded", this.maxStringBuffer);
                        }
                        _tmp = this.chars = Arrays.copyOf(this.chars, newSize);
                        _tmpLen = _tmp.length;
                    }
                    bc = this.buffer[this.currentIndex++];
                    switch (bc) {
                        case 98: {
                            bc = 8;
                            break block33;
                        }
                        case 116: {
                            bc = 9;
                            break block33;
                        }
                        case 110: {
                            bc = 10;
                            break block33;
                        }
                        case 102: {
                            bc = 12;
                            break block33;
                        }
                        case 114: {
                            bc = 13;
                            break block33;
                        }
                        case 34: 
                        case 47: 
                        case 92: {
                            break block33;
                        }
                        case 117: {
                            bc = (this.hexToInt(this.buffer[this.currentIndex++]) << 12) + (this.hexToInt(this.buffer[this.currentIndex++]) << 8) + (this.hexToInt(this.buffer[this.currentIndex++]) << 4) + this.hexToInt(this.buffer[this.currentIndex++]);
                            break block33;
                        }
                        default: {
                            throw this.newParseErrorWith("Invalid escape combination detected", bc);
                        }
                    }
                }
                if ((bc & 0x80) != 0) {
                    if (soFar >= _tmpLen - 4) {
                        newSize = this.chars.length * 2;
                        if (newSize > this.maxStringBuffer) {
                            throw this.newParseErrorWith("Maximum string buffer limit exceeded", this.maxStringBuffer);
                        }
                        _tmp = this.chars = Arrays.copyOf(this.chars, newSize);
                        _tmpLen = _tmp.length;
                    }
                    byte u2 = this.buffer[this.currentIndex++];
                    if ((bc & 0xE0) == 192) {
                        bc = ((bc & 0x1F) << 6) + (u2 & 0x3F);
                    } else {
                        byte u3 = this.buffer[this.currentIndex++];
                        if ((bc & 0xF0) == 224) {
                            bc = ((bc & 0xF) << 12) + ((u2 & 0x3F) << 6) + (u3 & 0x3F);
                        } else {
                            byte u4 = this.buffer[this.currentIndex++];
                            if ((bc & 0xF8) != 240) {
                                throw this.newParseErrorAt("Invalid unicode character detected", 0);
                            }
                            bc = ((bc & 7) << 18) + ((u2 & 0x3F) << 12) + ((u3 & 0x3F) << 6) + (u4 & 0x3F);
                            if (bc >= 65536) {
                                if (bc >= 0x110000) {
                                    throw this.newParseErrorAt("Invalid unicode character detected", 0);
                                }
                                int sup = bc - 65536;
                                _tmp[soFar++] = (char)((sup >>> 10) + 55296);
                                _tmp[soFar++] = (char)((sup & 0x3FF) + 56320);
                                continue;
                            }
                        }
                    }
                } else if (soFar >= _tmpLen) {
                    newSize = this.chars.length * 2;
                    if (newSize > this.maxStringBuffer) {
                        throw this.newParseErrorWith("Maximum string buffer limit exceeded", this.maxStringBuffer);
                    }
                    _tmp = this.chars = Arrays.copyOf(this.chars, newSize);
                    _tmpLen = _tmp.length;
                }
            }
            _tmp[soFar++] = (char)bc;
        }
        throw this.newParseErrorAt("JSON string was not closed with a double quote", 0);
    }

    private int hexToInt(byte value) {
        if (value >= 48 && value <= 57) {
            return value - 48;
        }
        if (value >= 65 && value <= 70) {
            return value - 55;
        }
        if (value >= 97 && value <= 102) {
            return value - 87;
        }
        throw this.newParseErrorWith("Could not parse unicode escape, expected a hexadecimal digit", value);
    }

    private boolean wasWhiteSpace() {
        switch (this.last) {
            case -96: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 32: {
                return true;
            }
            case -31: {
                if (this.currentIndex + 1 < this.length && this.buffer[this.currentIndex] == -102 && this.buffer[this.currentIndex + 1] == -128) {
                    this.currentIndex += 2;
                    this.last = (byte)32;
                    return true;
                }
                return false;
            }
            case -30: {
                if (this.currentIndex + 1 >= this.length) {
                    return false;
                }
                byte b1 = this.buffer[this.currentIndex];
                byte b2 = this.buffer[this.currentIndex + 1];
                if (b1 == -127 && b2 == -97) {
                    this.currentIndex += 2;
                    this.last = (byte)32;
                    return true;
                }
                if (b1 != -128) {
                    return false;
                }
                switch (b2) {
                    case -128: 
                    case -127: 
                    case -126: 
                    case -125: 
                    case -124: 
                    case -123: 
                    case -122: 
                    case -121: 
                    case -120: 
                    case -119: 
                    case -118: 
                    case -88: 
                    case -87: 
                    case -81: {
                        this.currentIndex += 2;
                        this.last = (byte)32;
                        return true;
                    }
                }
                return false;
            }
            case -29: {
                if (this.currentIndex + 1 < this.length && this.buffer[this.currentIndex] == -128 && this.buffer[this.currentIndex + 1] == -128) {
                    this.currentIndex += 2;
                    this.last = (byte)32;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean hasNextElement() {
        if (this.currentIndex >= this.length) {
            return false;
        }
        try {
            byte nextToken = this.nextToken();
            if (nextToken == 44) {
                this.nextToken();
                return true;
            }
            return nextToken != 93;
        }
        catch (JsonEofException e) {
            return false;
        }
    }

    @Override
    public byte nextToken() {
        this.read();
        if (WHITESPACE[this.last + 128]) {
            while (this.wasWhiteSpace()) {
                this.read();
            }
        }
        return this.last;
    }

    long positionInStream(int offset) {
        return this.currentPosition + (long)this.currentIndex - (long)offset;
    }

    long calcHash() {
        if (this.last != 34) {
            throw this.newParseError("Expecting '\"' for attribute name start");
        }
        this.tokenStart = this.currentIndex;
        int ci = this.currentIndex;
        long hash = -2128831035L;
        if (this.stream != null) {
            while (ci < this.readLimit) {
                byte b = this.buffer[ci];
                if (b == 92) {
                    if (ci == this.readLimit - 1) {
                        return this.calcHashAndCopyName(hash, ci);
                    }
                    b = this.buffer[++ci];
                } else if (b == 34) break;
                ++ci;
                hash ^= (long)b;
                hash *= 16777619L;
            }
            if (ci >= this.readLimit) {
                return this.calcHashAndCopyName(hash, ci);
            }
            this.nameEnd = this.currentIndex = ci + 1;
        } else {
            while (ci < this.buffer.length) {
                byte b;
                if ((b = this.buffer[ci++]) == 92) {
                    if (ci == this.buffer.length) {
                        throw this.newParseError("Expecting '\"' for attribute name end");
                    }
                    b = this.buffer[ci++];
                } else if (b == 34) break;
                hash ^= (long)b;
                hash *= 16777619L;
            }
            this.nameEnd = this.currentIndex = ci;
        }
        return hash;
    }

    private int calcHashAndCopyName(long hash, int ci) {
        int i;
        int soFar = ci - this.tokenStart;
        long startPosition = this.currentPosition - (long)soFar;
        while (this.chars.length < soFar) {
            this.chars = Arrays.copyOf(this.chars, this.chars.length * 2);
        }
        for (i = 0; i < soFar; ++i) {
            this.chars[i] = (char)this.buffer[i + this.tokenStart];
        }
        this.currentIndex = ci;
        do {
            byte b;
            if ((b = this.read()) == 92) {
                b = this.read();
            } else if (b == 34) {
                this.nameEnd = -1;
                this.lastNameLen = i;
                return (int)hash;
            }
            if (i == this.chars.length) {
                this.chars = Arrays.copyOf(this.chars, this.chars.length * 2);
            }
            this.chars[i++] = (char)b;
            hash ^= (long)b;
            hash *= 16777619L;
        } while (!this.isEndOfStream());
        throw this.newParseErrorAt("JSON string was not closed with a double quote", (int)startPosition);
    }

    private String lastFieldName() {
        if (this.stream != null && this.nameEnd == -1) {
            return new String(this.chars, 0, this.lastNameLen);
        }
        return new String(this.buffer, this.tokenStart, this.nameEnd - this.tokenStart - 1, StandardCharsets.UTF_8);
    }

    private byte skipString() {
        byte c = this.read();
        boolean inEscape = false;
        while (c != 34 || inEscape) {
            inEscape = !inEscape && c == 92;
            c = this.read();
        }
        return this.nextToken();
    }

    @Override
    public String readRaw() {
        this.readRawStartPosition = this.currentIndex - 1;
        if (this.stream != null) {
            this.readRawBuffer = new ByteArrayOutputStream();
        }
        this.skipValue();
        if (this.stream != null) {
            try {
                if (this.readRawBuffer.size() > 0) {
                    this.readRawBuffer.write(this.buffer, 0, this.currentIndex);
                    String string = new String(this.readRawBuffer.toByteArray(), utf8);
                    return string;
                }
            }
            finally {
                this.readRawBuffer = null;
            }
        }
        return new String(this.buffer, this.readRawStartPosition, this.currentIndex - this.readRawStartPosition, utf8);
    }

    @Override
    public void skipValue() {
        this.skipNextValue();
        this.last = this.buffer[--this.currentIndex];
    }

    private byte skipNextValue() {
        switch (this.last) {
            case 34: {
                return this.skipString();
            }
            case 123: {
                return this.skipObject();
            }
            case 91: {
                return this.skipArray();
            }
            case 110: {
                if (!this.isNullValue()) {
                    throw this.newParseErrorAt("Expecting 'null' for null constant", 0);
                }
                return this.nextToken();
            }
            case 116: {
                if (!this.wasTrue()) {
                    throw this.newParseErrorAt("Expecting 'true' for true constant", 0);
                }
                return this.nextToken();
            }
            case 102: {
                if (!this.wasFalse()) {
                    throw this.newParseErrorAt("Expecting 'false' for false constant", 0);
                }
                return this.nextToken();
            }
        }
        while (this.last != 44 && this.last != 125 && this.last != 93) {
            this.read();
        }
        return this.last;
    }

    private byte skipArray() {
        this.nextToken();
        byte nextToken = this.skipNextValue();
        while (nextToken == 44) {
            this.nextToken();
            nextToken = this.skipNextValue();
        }
        if (nextToken != 93) {
            throw this.newParseError("Expecting ']' for array end");
        }
        return this.nextToken();
    }

    private byte skipObject() {
        byte nextToken = this.nextToken();
        if (nextToken == 125) {
            return this.nextToken();
        }
        if (nextToken != 34) {
            throw this.newParseError("Expecting '\"' for attribute name");
        }
        nextToken = this.skipString();
        if (nextToken != 58) {
            throw this.newParseError("Expecting ':' after attribute name");
        }
        this.nextToken();
        nextToken = this.skipNextValue();
        while (nextToken == 44) {
            nextToken = this.nextToken();
            if (nextToken != 34) {
                throw this.newParseError("Expecting '\"' for attribute name");
            }
            nextToken = this.skipString();
            if (nextToken != 58) {
                throw this.newParseError("Expecting ':' after attribute name");
            }
            this.nextToken();
            nextToken = this.skipNextValue();
        }
        if (nextToken != 125) {
            throw this.newParseError("Expecting '}' for object end");
        }
        return this.nextToken();
    }

    @Override
    public byte[] readBinary() {
        if (this.stream != null && Base64.findEnd(this.buffer, this.currentIndex) == this.buffer.length) {
            int len = this.parseString();
            byte[] input = new byte[len];
            for (int i = 0; i < input.length; ++i) {
                input[i] = (byte)this.chars[i];
            }
            return Base64.decodeFast(input, 0, len);
        }
        if (this.last != 34) {
            throw this.newParseError("Expecting '\"' for base64 start");
        }
        int start = this.currentIndex;
        this.currentIndex = Base64.findEnd(this.buffer, start);
        this.last = this.buffer[this.currentIndex++];
        if (this.last != 34) {
            throw this.newParseError("Expecting '\"' for base64 end");
        }
        return Base64.decodeFast(this.buffer, start, this.currentIndex - 1);
    }

    @Override
    public String nextField() {
        if (this.currentNames != null) {
            long hash = this.calcHash();
            String key = this.currentNames.lookup(hash);
            if (key == null) {
                key = this.lastFieldName();
            }
            if (!(this.read() == 58 || this.wasWhiteSpace() && this.nextToken() == 58)) {
                throw this.newParseError("Expecting ':' after attribute name");
            }
            this.nextToken();
            return key;
        }
        return this.readKey();
    }

    private String readKey() {
        int len = this.parseString();
        String key = new String(this.chars, 0, len);
        if (this.nextToken() != 58) {
            throw this.newParseError("Expecting ':' after attribute name");
        }
        this.nextToken();
        return key;
    }

    @Override
    public boolean isNullValue() {
        if (this.last == 110) {
            if (this.currentIndex + 2 < this.length && this.buffer[this.currentIndex] == 117 && this.buffer[this.currentIndex + 1] == 108 && this.buffer[this.currentIndex + 2] == 108) {
                this.currentIndex += 3;
                this.last = (byte)108;
                return true;
            }
            throw this.newParseErrorAt("Invalid null constant found", 0);
        }
        return false;
    }

    private boolean wasTrue() {
        if (this.last == 116) {
            if (this.currentIndex + 2 < this.length && this.buffer[this.currentIndex] == 114 && this.buffer[this.currentIndex + 1] == 117 && this.buffer[this.currentIndex + 2] == 101) {
                this.currentIndex += 3;
                this.last = (byte)101;
                return true;
            }
            throw this.newParseErrorAt("Invalid true constant found", 0);
        }
        return false;
    }

    private boolean wasFalse() {
        if (this.last == 102) {
            if (this.currentIndex + 3 < this.length && this.buffer[this.currentIndex] == 97 && this.buffer[this.currentIndex + 1] == 108 && this.buffer[this.currentIndex + 2] == 115 && this.buffer[this.currentIndex + 3] == 101) {
                this.currentIndex += 4;
                this.last = (byte)101;
                return true;
            }
            throw this.newParseErrorAt("Invalid false constant found", 0);
        }
        return false;
    }

    @Override
    public void startStream() {
        if (this.last == 91) {
            return;
        }
        if (this.last == 123) {
            this.last = this.buffer[--this.currentIndex];
            return;
        }
        this.nextToken();
        if (this.last == 91) {
            return;
        }
        if (this.last == 123) {
            this.last = this.buffer[--this.currentIndex];
            return;
        }
        if (this.currentIndex >= this.length) {
            throw this.newParseErrorAt("Unexpected end in JSON", 0, eof);
        }
        throw this.newParseError("Expecting start of stream but got [" + this.last + "]");
    }

    @Override
    public void endStream() {
    }

    @Override
    public void startArray() {
        if (this.last != 91 && this.nextToken() != 91) {
            if (this.currentIndex >= this.length) {
                throw this.newParseErrorAt("Unexpected end in JSON", 0, eof);
            }
            throw this.newParseError("Expecting '[' as array start");
        }
    }

    @Override
    public void endArray() {
        if (this.last != 93 && this.nextToken() != 93) {
            if (this.currentIndex >= this.length) {
                throw this.newParseErrorAt("Unexpected end in JSON", 0, eof);
            }
            throw this.newParseError("Expecting ']' as array end");
        }
    }

    @Override
    public void startObject() {
        if (this.last != 123 && this.nextToken() != 123) {
            if (this.currentIndex >= this.length) {
                throw this.newParseErrorAt("Unexpected end in JSON", 0, eof);
            }
            throw this.newParseError("Expecting '{' as object start");
        }
    }

    @Override
    public void endObject() {
        this.currentNames = this.nameStack.poll();
        if (this.last != 125 && this.nextToken() != 125) {
            if (this.currentIndex >= this.length) {
                throw this.newParseErrorAt("Unexpected end in JSON", 0, eof);
            }
            throw this.newParseError("Expecting '}' as object end");
        }
    }

    JsonDataException newParseError(String description) {
        this.error.setLength(0);
        this.error.append(description);
        this.error.append(". Found ");
        this.error.append((char)this.last);
        this.error.append(" ");
        this.positionDescription(0, this.error);
        return new JsonDataException(this.error.toString());
    }

    JsonDataException newParseErrorAt(String description, int offset) {
        if (this.errorInfo == ErrorInfo.MINIMAL || this.errorInfo == ErrorInfo.DESCRIPTION_ONLY) {
            return new JsonDataException(description);
        }
        this.error.setLength(0);
        this.error.append(description);
        this.error.append(" ");
        this.positionDescription(offset, this.error);
        return new JsonDataException(this.error.toString());
    }

    JsonDataException newParseErrorAt(String description, int offset, Exception cause) {
        if (cause == null) {
            throw new IllegalArgumentException("cause can't be null");
        }
        if (this.errorInfo == ErrorInfo.MINIMAL) {
            return new JsonDataException(description, cause);
        }
        this.error.setLength(0);
        String msg = cause.getMessage();
        if (msg != null && msg.length() > 0) {
            this.error.append(msg);
            if (!msg.endsWith(".")) {
                this.error.append(".");
            }
            this.error.append(" ");
        }
        this.error.append(description);
        this.error.append(" ");
        this.positionDescription(offset, this.error);
        return new JsonDataException(this.error.toString());
    }

    JsonDataException newParseErrorFormat(String description, int offset, String extraFormat, Object ... args) {
        if (this.errorInfo == ErrorInfo.MINIMAL) {
            return new JsonDataException(description);
        }
        this.error.setLength(0);
        this.errorFormatter.format(extraFormat, args);
        this.error.append(" ");
        this.positionDescription(offset, this.error);
        return new JsonDataException(this.error.toString());
    }

    JsonDataException newParseErrorWith(String description, Object argument) {
        return this.newParseErrorWith(description, 0, description, argument, "");
    }

    JsonDataException newParseErrorWith(String description, int offset, String extra, Object extraArgument, String extraSuffix) {
        if (this.errorInfo == ErrorInfo.MINIMAL) {
            return new JsonDataException(description);
        }
        this.error.setLength(0);
        this.error.append(extra);
        if (extraArgument != null) {
            this.error.append(": '").append(extraArgument).append("'");
        }
        this.error.append(extraSuffix);
        this.error.append(" ");
        this.positionDescription(offset, this.error);
        return new JsonDataException(this.error.toString());
    }

    static {
        JParser.WHITESPACE[137] = true;
        JParser.WHITESPACE[138] = true;
        JParser.WHITESPACE[139] = true;
        JParser.WHITESPACE[140] = true;
        JParser.WHITESPACE[141] = true;
        JParser.WHITESPACE[160] = true;
        JParser.WHITESPACE[32] = true;
        JParser.WHITESPACE[97] = true;
        JParser.WHITESPACE[98] = true;
        JParser.WHITESPACE[99] = true;
        eof = new EmptyEOFException();
    }

    static enum ErrorInfo {
        WITH_STACK_TRACE,
        DESCRIPTION_AND_POSITION,
        DESCRIPTION_ONLY,
        MINIMAL;

    }

    static enum DoublePrecision {
        EXACT(0),
        HIGH(1),
        DEFAULT(3),
        LOW(4);

        final int level;

        private DoublePrecision(int level) {
            this.level = level;
        }
    }

    static enum UnknownNumberParsing {
        LONG_AND_BIGDECIMAL,
        LONG_AND_DOUBLE,
        BIGDECIMAL,
        DOUBLE;

    }

    private static class EmptyEOFException
    extends EOFException {
        private EmptyEOFException() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

