/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.stream;

import io.avaje.jsonb.stream.JGenerator;
import io.avaje.jsonb.stream.JParser;
import io.avaje.jsonb.stream.JsonGenerator;
import io.avaje.jsonb.stream.JsonParser;
import java.io.InputStream;
import java.io.OutputStream;

final class Recycle {
    private static final int GENERATOR_BUFFER_SIZE = Integer.getInteger("jsonb.generatorBufferSize", 4096);
    private static final int PARSER_BUFFER_SIZE = Integer.getInteger("jsonb.parserBufferSize", 4096);
    private static final int PARSER_CHAR_BUFFER_SIZE = Integer.getInteger("jsonb.parserCharBufferSize", 4096);
    private static boolean jvmRecycle;
    private static ThreadLocal<JParser> read;
    private static ThreadLocal<JGenerator> managed;

    private Recycle() {
    }

    static JsonGenerator generator(OutputStream target) {
        return (jvmRecycle ? Recycle.createGenerator() : managed.get()).prepare(target);
    }

    static JsonGenerator generator() {
        return (jvmRecycle ? Recycle.createGenerator() : managed.get()).prepare(null);
    }

    static JsonParser parser(byte[] bytes) {
        return (jvmRecycle ? Recycle.createParser() : read.get()).process(bytes, bytes.length);
    }

    static JsonParser parser(InputStream in) {
        return (jvmRecycle ? Recycle.createParser() : read.get()).process(in);
    }

    static JGenerator createGenerator() {
        return new JGenerator(GENERATOR_BUFFER_SIZE);
    }

    static JParser createParser() {
        char[] ch = new char[PARSER_CHAR_BUFFER_SIZE];
        byte[] by = new byte[PARSER_BUFFER_SIZE];
        return new JParser(ch, by, 0, JParser.ErrorInfo.MINIMAL, JParser.DoublePrecision.DEFAULT, JParser.UnknownNumberParsing.BIGDECIMAL, 100, 50000);
    }

    static {
        if (Boolean.getBoolean("jsonb.useJVMBufferRecycling")) {
            jvmRecycle = true;
        } else {
            managed = ThreadLocal.withInitial(Recycle::createGenerator);
            read = ThreadLocal.withInitial(Recycle::createParser);
        }
    }
}

