/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.core;

import io.avaje.jsonb.JsonAdapter;
import io.avaje.jsonb.JsonReader;
import io.avaje.jsonb.JsonWriter;
import io.avaje.jsonb.core.Util;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;

final class ArrayAdapter
extends JsonAdapter<Object> {
    static final JsonAdapter.Factory FACTORY = (type, jsonb) -> {
        Type elementType = Util.arrayComponentType(type);
        if (elementType == null) {
            return null;
        }
        if (elementType == Byte.TYPE) {
            return new ByteArray();
        }
        Class<?> elementClass = Util.rawType(elementType);
        JsonAdapter<Object> elementAdapter = jsonb.adapter(elementType);
        return new ArrayAdapter(elementClass, elementAdapter).nullSafe();
    };
    private final Class<?> elementClass;
    private final JsonAdapter<Object> elementAdapter;

    ArrayAdapter(Class<?> elementClass, JsonAdapter<Object> elementAdapter) {
        this.elementClass = elementClass;
        this.elementAdapter = elementAdapter;
    }

    @Override
    public Object fromJson(JsonReader reader) {
        ArrayList<Object> list = new ArrayList<Object>();
        reader.beginArray();
        while (reader.hasNextElement()) {
            list.add(this.elementAdapter.fromJson(reader));
        }
        reader.endArray();
        Object array = Array.newInstance(this.elementClass, list.size());
        for (int i = 0; i < list.size(); ++i) {
            Array.set(array, i, list.get(i));
        }
        return array;
    }

    @Override
    public void toJson(JsonWriter writer, Object value) {
        writer.beginArray();
        int size = Array.getLength(value);
        for (int i = 0; i < size; ++i) {
            this.elementAdapter.toJson(writer, Array.get(value, i));
        }
        writer.endArray();
    }

    public String toString() {
        return String.valueOf(this.elementAdapter) + ".array()";
    }

    static final class ByteArray
    extends JsonAdapter<byte[]> {
        ByteArray() {
        }

        @Override
        public byte[] fromJson(JsonReader reader) {
            return reader.readBinary();
        }

        @Override
        public void toJson(JsonWriter writer, byte[] value) {
            writer.value(value);
        }

        public String toString() {
            return "JsonAdapter(byte[])";
        }
    }
}

