/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.core;

import io.avaje.jsonb.JsonAdapter;
import io.avaje.jsonb.JsonReader;
import io.avaje.jsonb.JsonWriter;
import io.avaje.jsonb.core.ArrayAdapter;
import io.avaje.jsonb.core.BasicTypeAdapters;
import io.avaje.jsonb.core.CollectionAdapter;
import io.avaje.jsonb.core.DJsonb;
import io.avaje.jsonb.core.JavaTimeAdapters;
import io.avaje.jsonb.core.MapAdapter;
import io.avaje.jsonb.core.MathAdapters;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

final class CoreAdapterBuilder {
    private final DJsonb context;
    private final List<JsonAdapter.Factory> factories;
    private final ThreadLocal<LookupChain> lookupChainThreadLocal = new ThreadLocal();
    private final Map<Object, JsonAdapter<?>> adapterCache = new ConcurrentHashMap();
    private final ReentrantLock lock = new ReentrantLock();

    CoreAdapterBuilder(DJsonb context, List<JsonAdapter.Factory> userFactories, boolean mathAsString) {
        this.context = context;
        this.factories = new ArrayList<JsonAdapter.Factory>();
        this.factories.addAll(userFactories);
        this.factories.add(BasicTypeAdapters.FACTORY);
        this.factories.add(JavaTimeAdapters.FACTORY);
        this.factories.add(new MathAdapters(mathAsString));
        this.factories.add(CollectionAdapter.FACTORY);
        this.factories.add(MapAdapter.FACTORY);
        this.factories.add(ArrayAdapter.FACTORY);
    }

    <T> JsonAdapter<T> get(Object cacheKey) {
        return this.adapterCache.get(cacheKey);
    }

    <T> JsonAdapter<T> build(Type type) {
        return this.build(type, type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <T> JsonAdapter<T> build(Type type, Object cacheKey) {
        LookupChain lookupChain = this.lookupChainThreadLocal.get();
        if (lookupChain == null) {
            lookupChain = new LookupChain();
            this.lookupChainThreadLocal.set(lookupChain);
        }
        boolean success = false;
        JsonAdapter adapterFromCall = lookupChain.push(type, cacheKey);
        try {
            if (adapterFromCall != null) {
                JsonAdapter jsonAdapter = adapterFromCall;
                return jsonAdapter;
            }
            Iterator<JsonAdapter.Factory> iterator = this.factories.iterator();
            while (iterator.hasNext()) {
                JsonAdapter.Factory factory = iterator.next();
                JsonAdapter<?> result = factory.create(type, this.context);
                if (result != null) {
                    lookupChain.adapterFound(result);
                    success = true;
                    JsonAdapter<?> jsonAdapter = result;
                    return jsonAdapter;
                }
            }
            throw new IllegalArgumentException("No JsonAdapter for " + String.valueOf(type) + ". Perhaps needs @Json or @Json.Import?");
        }
        catch (IllegalArgumentException e) {
            throw lookupChain.exceptionWithLookupStack(e);
        }
        finally {
            lookupChain.pop(success);
        }
    }

    final class LookupChain {
        final List<Lookup<?>> callLookups = new ArrayList();
        final Deque<Lookup<?>> stack = new ArrayDeque();
        boolean exceptionAnnotated;

        LookupChain() {
        }

        <T> JsonAdapter<T> push(Type type, Object cacheKey) {
            for (Lookup<?> lookup : this.callLookups) {
                if (!lookup.cacheKey.equals(cacheKey)) continue;
                Lookup<?> hit = lookup;
                this.stack.add(hit);
                return hit.adapter != null ? hit.adapter : hit;
            }
            Lookup lookup = new Lookup(type, cacheKey);
            this.callLookups.add(lookup);
            this.stack.add(lookup);
            return null;
        }

        <T> void adapterFound(JsonAdapter<T> result) {
            Lookup<?> currentLookup = this.stack.getLast();
            currentLookup.adapter = result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void pop(boolean success) {
            this.stack.removeLast();
            if (!this.stack.isEmpty()) {
                return;
            }
            CoreAdapterBuilder.this.lookupChainThreadLocal.remove();
            if (success) {
                CoreAdapterBuilder.this.lock.lock();
                try {
                    for (Lookup<?> lookup : this.callLookups) {
                        JsonAdapter replaced = CoreAdapterBuilder.this.adapterCache.put(lookup.cacheKey, lookup.adapter);
                        if (replaced == null) continue;
                        lookup.adapter = replaced;
                        CoreAdapterBuilder.this.adapterCache.put(lookup.cacheKey, replaced);
                    }
                }
                finally {
                    CoreAdapterBuilder.this.lock.unlock();
                }
            }
        }

        IllegalArgumentException exceptionWithLookupStack(IllegalArgumentException e) {
            if (this.exceptionAnnotated) {
                return e;
            }
            this.exceptionAnnotated = true;
            int size = this.stack.size();
            if (size == 1) {
                return e;
            }
            StringBuilder errorMessageBuilder = new StringBuilder(e.getMessage());
            Iterator<Lookup<?>> i = this.stack.descendingIterator();
            while (i.hasNext()) {
                Lookup<?> lookup = i.next();
                errorMessageBuilder.append("\nfor ").append(lookup.type);
            }
            return new IllegalArgumentException(errorMessageBuilder.toString(), e);
        }
    }

    static final class Lookup<T>
    extends JsonAdapter<T> {
        final Type type;
        final Object cacheKey;
        JsonAdapter<T> adapter;

        Lookup(Type type, Object cacheKey) {
            this.type = type;
            this.cacheKey = cacheKey;
        }

        @Override
        public T fromJson(JsonReader reader) {
            if (this.adapter == null) {
                throw new IllegalStateException("JsonAdapter isn't ready");
            }
            return this.adapter.fromJson(reader);
        }

        @Override
        public void toJson(JsonWriter writer, T value) {
            if (this.adapter == null) {
                throw new IllegalStateException("JsonAdapter isn't ready");
            }
            this.adapter.toJson(writer, value);
        }

        public String toString() {
            return this.adapter != null ? this.adapter.toString() : super.toString();
        }
    }
}

