/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.stream;

import io.avaje.jsonb.stream.JsonOutput;
import io.helidon.common.http.Http;
import io.helidon.nima.webserver.http.ServerResponse;
import java.io.IOException;
import java.io.OutputStream;

final class NimaJsonOutput
implements JsonOutput {
    private final ServerResponse res;
    private OutputStream os;
    private boolean fixedLength;

    NimaJsonOutput(ServerResponse res) {
        this.res = res;
    }

    private OutputStream os() {
        if (this.os == null) {
            if (!this.fixedLength) {
                this.res.header(Http.HeaderValues.TRANSFER_ENCODING_CHUNKED);
            }
            this.os = this.res.outputStream();
        }
        return this.os;
    }

    @Override
    public void write(byte[] content, int offset, int length) throws IOException {
        this.os().write(content, offset, length);
    }

    @Override
    public void writeLast(byte[] content, int offset, int length) throws IOException {
        if (offset == 0 && this.os == null) {
            this.fixedLength = true;
            this.res.contentLength((long)length);
        }
        this.os().write(content, offset, length);
    }

    @Override
    public void flush() throws IOException {
        if (this.os != null) {
            this.os.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.os != null) {
            this.os.close();
        }
    }

    @Override
    public OutputStream unwrapOutputStream() {
        return this.res.outputStream();
    }
}

