/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.core;

import io.avaje.jsonb.JsonAdapter;
import io.avaje.jsonb.JsonDataException;
import io.avaje.jsonb.JsonReader;
import io.avaje.jsonb.JsonWriter;
import io.avaje.jsonb.Jsonb;
import io.avaje.jsonb.core.Util;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;

final class MapAdapter<V>
implements JsonAdapter<Map<String, V>> {
    static final JsonAdapter.Factory FACTORY = (type, jsonb) -> {
        Class<?> rawType = Util.rawType(type);
        if (rawType != Map.class) {
            return null;
        }
        Type valueType = Util.mapValueType(type, rawType);
        return new MapAdapter(jsonb, valueType).nullSafe();
    };
    private final JsonAdapter<V> valueAdapter;

    MapAdapter(Jsonb jsonb, Type valueType) {
        this.valueAdapter = jsonb.adapter(valueType);
    }

    @Override
    public void toJson(JsonWriter writer, Map<String, V> map) {
        writer.beginObject();
        for (Map.Entry<String, V> entry : map.entrySet()) {
            if (entry.getKey() == null) {
                throw new JsonDataException("Map key is null at " + writer.path());
            }
            writer.name(entry.getKey());
            this.valueAdapter.toJson(writer, entry.getValue());
        }
        writer.endObject();
    }

    @Override
    public Map<String, V> fromJson(JsonReader reader) {
        LinkedHashMap<String, V> result = new LinkedHashMap<String, V>();
        reader.beginObject();
        while (reader.hasNextField()) {
            V value;
            String name = reader.nextField();
            V replaced = result.put(name, value = this.valueAdapter.fromJson(reader));
            if (replaced == null) continue;
            throw new JsonDataException(String.format("Map key '%s' has multiple values at path %s : %s and %s", name, reader.location(), replaced, value));
        }
        reader.endObject();
        return result;
    }

    public String toString() {
        return "MapAdapter(" + String.valueOf(this.valueAdapter) + ")";
    }
}

