/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.core;

import io.avaje.jsonb.JsonReader;
import io.avaje.jsonb.spi.PropertyNames;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

final class ObjectJsonReader
implements JsonReader {
    private final Object source;
    private Object currentValue;
    private Iterator<?> collectionIterator;
    private Iterator<Map.Entry<String, Object>> mapIterator;

    ObjectJsonReader(Object source) {
        this.source = source;
        this.currentValue = source;
    }

    @Override
    public void unmappedField(String fieldName) {
    }

    @Override
    public void close() {
    }

    @Override
    public void skipValue() {
    }

    @Override
    public void beginArray() {
        this.collectionIterator = ((Collection)this.currentValue).iterator();
    }

    @Override
    public void endArray() {
    }

    @Override
    public boolean hasNextElement() {
        if (this.collectionIterator.hasNext()) {
            this.currentValue = this.collectionIterator.next();
            return true;
        }
        return false;
    }

    @Override
    public void beginObject() {
        Map map = (Map)this.currentValue;
        this.mapIterator = map.entrySet().iterator();
    }

    @Override
    public void beginObject(PropertyNames names) {
        this.beginObject();
    }

    @Override
    public void endObject() {
    }

    @Override
    public boolean hasNextField() {
        return this.mapIterator.hasNext();
    }

    @Override
    public String nextField() {
        Map.Entry<String, Object> mapEntry = this.mapIterator.next();
        this.currentValue = mapEntry.getValue();
        return mapEntry.getKey();
    }

    @Override
    public boolean readBoolean() {
        if (this.currentValue instanceof Boolean) {
            return (Boolean)this.currentValue;
        }
        return Boolean.parseBoolean(this.currentValue.toString());
    }

    @Override
    public int readInt() {
        if (this.currentValue instanceof Integer) {
            return (Integer)this.currentValue;
        }
        return Integer.parseInt(this.currentValue.toString());
    }

    @Override
    public long readLong() {
        if (this.currentValue instanceof Long) {
            return (Long)this.currentValue;
        }
        return Long.parseLong(this.currentValue.toString());
    }

    @Override
    public double readDouble() {
        if (this.currentValue instanceof Double) {
            return (Double)this.currentValue;
        }
        return Double.parseDouble(this.currentValue.toString());
    }

    @Override
    public String readString() {
        if (this.currentValue instanceof String) {
            return (String)this.currentValue;
        }
        return this.currentValue.toString();
    }

    @Override
    public String readRaw() {
        if (this.currentValue instanceof String) {
            return (String)this.currentValue;
        }
        return this.currentValue.toString();
    }

    @Override
    public BigDecimal readDecimal() {
        if (this.currentValue instanceof BigDecimal) {
            return (BigDecimal)this.currentValue;
        }
        return new BigDecimal(this.currentValue.toString());
    }

    @Override
    public BigInteger readBigInteger() {
        if (this.currentValue instanceof BigInteger) {
            return (BigInteger)this.currentValue;
        }
        return new BigInteger(this.currentValue.toString());
    }

    @Override
    public byte[] readBinary() {
        return (byte[])this.currentValue;
    }

    @Override
    public boolean isNullValue() {
        return this.currentValue == null;
    }

    @Override
    public String location() {
        return "unknown";
    }

    @Override
    public JsonReader.Token currentToken() {
        throw new IllegalStateException("not called");
    }

    public String toString() {
        return String.valueOf(this.source);
    }
}

