/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.core;

import io.avaje.jsonb.JsonAdapter;
import io.avaje.jsonb.JsonReader;
import io.avaje.jsonb.JsonWriter;
import io.avaje.jsonb.Jsonb;
import io.avaje.jsonb.Types;
import io.avaje.jsonb.spi.ViewBuilderAware;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

class OptionalAdapters {
    public static final JsonAdapter.Factory FACTORY = (type, jsonb) -> {
        if (Types.isGenericTypeOf(type, Optional.class)) {
            Type[] args = Types.typeArguments(type);
            return new OptionalAdapter(jsonb, args[0]).nullSafe();
        }
        if (type == OptionalInt.class) {
            return new OptionalIntAdapter().nullSafe();
        }
        if (type == OptionalDouble.class) {
            return new OptionalDoubleAdapter().nullSafe();
        }
        if (type == OptionalLong.class) {
            return new OptionalLongAdapter().nullSafe();
        }
        return null;
    };

    private OptionalAdapters() {
    }

    static class OptionalAdapter<T>
    implements JsonAdapter<Optional<T>> {
        private final JsonAdapter<T> delegate;

        public OptionalAdapter(Jsonb jsonb, Type param0) {
            this.delegate = jsonb.adapter(param0);
        }

        @Override
        public void toJson(JsonWriter writer, Optional<T> value) {
            this.delegate.toJson(writer, value.orElse(null));
        }

        @Override
        public Optional<T> fromJson(JsonReader reader) {
            return Optional.ofNullable(this.delegate.fromJson(reader));
        }

        @Override
        public boolean isViewBuilderAware() {
            return this.delegate.isViewBuilderAware();
        }

        @Override
        public ViewBuilderAware viewBuild() {
            return this.delegate.viewBuild();
        }

        public String toString() {
            return String.valueOf(this.delegate) + ".optional()";
        }
    }

    static final class OptionalIntAdapter
    implements JsonAdapter<OptionalInt> {
        OptionalIntAdapter() {
        }

        @Override
        public OptionalInt fromJson(JsonReader reader) {
            return OptionalInt.of(reader.readInt());
        }

        @Override
        public void toJson(JsonWriter writer, OptionalInt value) {
            value.ifPresentOrElse(writer::value, writer::nullValue);
        }

        public String toString() {
            return "JsonAdapter(OptionalInt)";
        }
    }

    static final class OptionalDoubleAdapter
    implements JsonAdapter<OptionalDouble> {
        OptionalDoubleAdapter() {
        }

        @Override
        public OptionalDouble fromJson(JsonReader reader) {
            return OptionalDouble.of(reader.readDouble());
        }

        @Override
        public void toJson(JsonWriter writer, OptionalDouble value) {
            value.ifPresentOrElse(writer::value, writer::nullValue);
        }

        public String toString() {
            return "JsonAdapter(OptionalDouble)";
        }
    }

    static final class OptionalLongAdapter
    implements JsonAdapter<OptionalLong> {
        OptionalLongAdapter() {
        }

        @Override
        public OptionalLong fromJson(JsonReader reader) {
            return OptionalLong.of(reader.readLong());
        }

        @Override
        public void toJson(JsonWriter writer, OptionalLong value) {
            value.ifPresentOrElse(writer::value, writer::nullValue);
        }

        public String toString() {
            return "JsonAdapter(OptionalLong)";
        }
    }
}

