/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.stream;

import io.avaje.jsonb.JsonIoException;
import io.avaje.jsonb.JsonWriter;
import io.avaje.jsonb.spi.PropertyNames;
import io.avaje.jsonb.stream.JsonGenerator;
import io.avaje.jsonb.stream.JsonNames;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;

final class JsonWriteAdapter
implements JsonWriter {
    final JsonGenerator generator;
    private boolean serializeEmpty;
    private boolean serializeNulls;
    private String deferredName;
    private int namePos = -1;

    JsonWriteAdapter(JsonGenerator generator, boolean serializeNulls, boolean serializeEmpty) {
        this.generator = generator;
        this.serializeNulls = serializeNulls;
        this.serializeEmpty = serializeEmpty;
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        return type.cast(this.generator);
    }

    @Override
    public void markIncomplete() {
        this.generator.markIncomplete();
    }

    @Override
    public void close() {
        this.generator.close();
    }

    @Override
    public void flush() {
        this.generator.flush();
    }

    @Override
    public void pretty(boolean pretty) {
        this.generator.pretty(pretty);
    }

    @Override
    public void serializeNulls(boolean serializeNulls) {
        this.serializeNulls = serializeNulls;
    }

    @Override
    public boolean serializeNulls() {
        return this.serializeNulls;
    }

    @Override
    public boolean serializeEmpty() {
        return this.serializeEmpty;
    }

    @Override
    public void serializeEmpty(boolean serializeEmpty) {
        this.serializeEmpty = serializeEmpty;
    }

    @Override
    public String path() {
        return this.generator.toString();
    }

    @Override
    public void beginArray() {
        try {
            this.writeDeferredName();
            this.generator.startArray();
        }
        catch (IOException e) {
            throw new JsonIoException(e);
        }
    }

    @Override
    public void endArray() {
        this.generator.endArray();
    }

    @Override
    public void beginObject() {
        try {
            this.writeDeferredName();
            this.generator.startObject();
        }
        catch (IOException e) {
            throw new JsonIoException(e);
        }
    }

    @Override
    public void beginObject(PropertyNames names) {
        try {
            this.writeDeferredName();
            this.generator.startObject((JsonNames)names);
        }
        catch (IOException e) {
            throw new JsonIoException(e);
        }
    }

    @Override
    public void endObject() {
        this.generator.endObject();
    }

    @Override
    public void name(String name) {
        this.deferredName = name;
    }

    @Override
    public void allNames(PropertyNames names) {
        this.generator.allNames((JsonNames)names);
    }

    @Override
    public void name(int position) {
        this.namePos = position;
    }

    void writeDeferredName() throws IOException {
        if (this.namePos > -1) {
            this.generator.writeName(this.namePos);
            this.namePos = -1;
        } else if (this.deferredName != null) {
            this.generator.writeName(this.deferredName);
            this.deferredName = null;
        }
    }

    @Override
    public void emptyArray() {
        if (this.serializeEmpty) {
            try {
                this.writeDeferredName();
                this.generator.startArray();
                this.generator.endArray();
            }
            catch (IOException e) {
                throw new JsonIoException(e);
            }
        } else if (this.namePos >= 0) {
            this.namePos = -1;
        } else if (this.deferredName != null) {
            this.deferredName = null;
        }
    }

    @Override
    public void nullValue() {
        try {
            if (this.serializeNulls) {
                this.writeDeferredName();
                this.generator.writeNull();
            } else if (this.namePos >= 0) {
                this.namePos = -1;
            } else if (this.deferredName != null) {
                this.deferredName = null;
            }
        }
        catch (IOException e) {
            throw new JsonIoException(e);
        }
    }

    @Override
    public void value(String value) {
        if (value == null) {
            this.nullValue();
        } else {
            try {
                this.writeDeferredName();
                this.generator.write(value);
            }
            catch (IOException e) {
                throw new JsonIoException(e);
            }
        }
    }

    @Override
    public void value(boolean value) {
        try {
            this.writeDeferredName();
            this.generator.write(value);
        }
        catch (IOException e) {
            throw new JsonIoException(e);
        }
    }

    @Override
    public void value(int value) {
        try {
            this.writeDeferredName();
            this.generator.write(value);
        }
        catch (IOException e) {
            throw new JsonIoException(e);
        }
    }

    @Override
    public void value(long value) {
        try {
            this.writeDeferredName();
            this.generator.write(value);
        }
        catch (IOException e) {
            throw new JsonIoException(e);
        }
    }

    @Override
    public void value(double value) {
        try {
            this.writeDeferredName();
            this.generator.write(value);
        }
        catch (IOException e) {
            throw new JsonIoException(e);
        }
    }

    @Override
    public void value(Boolean value) {
        if (value == null) {
            this.nullValue();
        } else {
            try {
                this.writeDeferredName();
                this.generator.write(value);
            }
            catch (IOException e) {
                throw new JsonIoException(e);
            }
        }
    }

    @Override
    public void value(Integer value) {
        if (value == null) {
            this.nullValue();
        } else {
            try {
                this.writeDeferredName();
                this.generator.write(value);
            }
            catch (IOException e) {
                throw new JsonIoException(e);
            }
        }
    }

    @Override
    public void value(Long value) {
        if (value == null) {
            this.nullValue();
        } else {
            try {
                this.writeDeferredName();
                this.generator.write(value);
            }
            catch (IOException e) {
                throw new JsonIoException(e);
            }
        }
    }

    @Override
    public void value(Double value) {
        if (value == null) {
            this.nullValue();
        } else {
            try {
                this.writeDeferredName();
                this.generator.write(value);
            }
            catch (IOException e) {
                throw new JsonIoException(e);
            }
        }
    }

    @Override
    public void value(BigDecimal value) {
        if (value == null) {
            this.nullValue();
        } else {
            try {
                this.writeDeferredName();
                this.generator.write(value);
            }
            catch (IOException e) {
                throw new JsonIoException(e);
            }
        }
    }

    @Override
    public void value(BigInteger value) {
        if (value == null) {
            this.nullValue();
        } else {
            try {
                this.writeDeferredName();
                this.generator.write(value);
            }
            catch (IOException e) {
                throw new JsonIoException(e);
            }
        }
    }

    @Override
    public void value(byte[] value) {
        if (value == null) {
            this.nullValue();
        } else {
            try {
                this.writeDeferredName();
                this.generator.write(value);
            }
            catch (IOException e) {
                throw new JsonIoException(e);
            }
        }
    }

    @Override
    public void rawValue(String value) {
        if (value == null) {
            this.nullValue();
        } else {
            try {
                this.writeDeferredName();
                this.generator.writeRaw(value);
            }
            catch (IOException e) {
                throw new JsonIoException(e);
            }
        }
    }

    @Override
    public void writeNewLine() {
        this.generator.writeNewLine();
    }

    @Override
    public void jsonValue(Object value) {
        if (value instanceof Map) {
            this.writeMap((Map)value);
        } else if (value instanceof List) {
            this.writeList((List)value);
        } else if (value instanceof Collection) {
            this.writeCollection((Collection)value);
        } else if (value instanceof String) {
            this.value((String)value);
        } else if (value instanceof Boolean) {
            this.value((boolean)((Boolean)value));
        } else if (value instanceof Integer) {
            this.value((int)((Integer)value));
        } else if (value instanceof Long) {
            this.value((long)((Long)value));
        } else if (value instanceof Double) {
            this.value((double)((Double)value));
        } else if (value instanceof BigDecimal) {
            this.value((BigDecimal)value);
        } else if (value instanceof byte[]) {
            this.value((byte[])value);
        } else if (value == null) {
            this.nullValue();
        } else {
            throw new IllegalArgumentException("Unsupported type: " + value.getClass().getName());
        }
    }

    private void writeList(List<?> value) {
        this.beginArray();
        for (Object element : value) {
            this.jsonValue(element);
        }
        this.endArray();
    }

    private void writeCollection(Collection<?> value) {
        this.beginArray();
        for (Object element : value) {
            this.jsonValue(element);
        }
        this.endArray();
    }

    private void writeMap(Map<?, ?> value) {
        this.beginObject();
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            Object key = entry.getKey();
            if (!(key instanceof String)) {
                throw new IllegalArgumentException((String)(key == null ? "Map keys must be non-null" : "Map keys must be of type String: " + key.getClass().getName()));
            }
            this.name((String)key);
            this.jsonValue(entry.getValue());
        }
        this.endObject();
    }
}

