/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb;

import io.avaje.jsonb.JsonAdapter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.SOURCE)
public @interface Json {
    public Naming naming() default Naming.Match;

    public String typeProperty() default "@type";

    public boolean caseInsensitiveKeys() default false;

    public static enum Naming {
        Match,
        LowerHyphen,
        LowerUnderscore,
        LowerSpace,
        UpperCamel,
        UpperHyphen,
        UpperUnderscore,
        UpperSpace;

    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD})
    public static @interface Serializer {
        public Class<? extends JsonAdapter<?>> value();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.CONSTRUCTOR, ElementType.METHOD})
    public static @interface Creator {
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MixIn {
        public Class<?> value();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD})
    public static @interface Raw {
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SubTypes {
        public SubType[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.SOURCE)
    @Repeatable(value=SubTypes.class)
    public static @interface SubType {
        public Class<?> type();

        public String name() default "";
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Value {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
    public static @interface Unmapped {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Ignore {
        public boolean serialize() default false;

        public boolean deserialize() default false;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER})
    public static @interface Alias {
        public String[] value();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD})
    public static @interface Property {
        public String value();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Repeatable(value=Imports.class)
    @Target(value={ElementType.TYPE, ElementType.PACKAGE, ElementType.MODULE})
    public static @interface Import {
        public Class<?>[] value();

        public Json jsonSettings() default @Json;

        public SubType[] subtypes() default {};

        public Class<?> implementation() default Void.class;

        @Retention(value=RetentionPolicy.SOURCE)
        @Target(value={ElementType.TYPE, ElementType.PACKAGE, ElementType.MODULE})
        public static @interface Imports {
            public Import[] value();
        }
    }
}

