/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.core;

import io.avaje.jsonb.JsonAdapter;
import io.avaje.jsonb.JsonDataException;
import io.avaje.jsonb.JsonReader;
import io.avaje.jsonb.JsonWriter;
import io.avaje.jsonb.Jsonb;
import io.avaje.jsonb.core.Util;
import java.lang.reflect.Type;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

final class BasicTypeAdapters {
    static final JsonAdapter.Factory FACTORY = (type, jsonb) -> {
        if (type == Boolean.TYPE) {
            return new BooleanAdapter();
        }
        if (type == Byte.TYPE) {
            return new ByteAdapter();
        }
        if (type == Character.TYPE) {
            return new CharacterAdapter();
        }
        if (type == Double.TYPE) {
            return new DoubleAdapter();
        }
        if (type == Float.TYPE) {
            return new FloatAdapter();
        }
        if (type == Integer.TYPE) {
            return new IntegerAdapter();
        }
        if (type == Long.TYPE) {
            return new LongAdapter();
        }
        if (type == Short.TYPE) {
            return new ShortAdapter();
        }
        if (type == Boolean.class) {
            return new BooleanAdapter().nullSafe();
        }
        if (type == Byte.class) {
            return new ByteAdapter().nullSafe();
        }
        if (type == Character.class) {
            return new CharacterAdapter().nullSafe();
        }
        if (type == Double.class) {
            return new DoubleAdapter().nullSafe();
        }
        if (type == Float.class) {
            return new FloatAdapter().nullSafe();
        }
        if (type == Integer.class) {
            return new IntegerAdapter().nullSafe();
        }
        if (type == Long.class) {
            return new LongAdapter().nullSafe();
        }
        if (type == Short.class) {
            return new ShortAdapter().nullSafe();
        }
        if (type == String.class) {
            return new StringAdapter().nullSafe();
        }
        if (type == UUID.class) {
            return new UuidAdapter().nullSafe();
        }
        if (type == URL.class) {
            return new UrlAdapter().nullSafe();
        }
        if (type == URI.class) {
            return new UriAdapter().nullSafe();
        }
        if (type == InetAddress.class) {
            return new InetAddressAdapter().nullSafe();
        }
        if (type == Inet4Address.class) {
            return new InetAddressAdapter().nullSafe();
        }
        if (type == Inet6Address.class) {
            return new InetAddressAdapter().nullSafe();
        }
        if (type == StackTraceElement.class) {
            return new StackTraceElementAdapter().nullSafe();
        }
        if (type == Object.class) {
            return new ObjectJsonAdapter(jsonb).nullSafe();
        }
        if (type == Throwable.class) {
            return new ThrowableAdapter(jsonb).nullSafe();
        }
        Class<?> rawType = Util.rawType(type);
        if (rawType.isEnum()) {
            return new EnumJsonAdapter(rawType).nullSafe();
        }
        return null;
    };

    BasicTypeAdapters() {
    }

    static int rangeCheckNextInt(JsonReader reader, String typeMessage, int min, int max) {
        int value = reader.readInt();
        if (value >= min && value <= max) {
            return value;
        }
        throw new JsonDataException(String.format("Expected %s but was %s at path %s", typeMessage, value, reader.location()));
    }

    static final class BooleanAdapter
    implements JsonAdapter<Boolean> {
        BooleanAdapter() {
        }

        @Override
        public Boolean fromJson(JsonReader reader) {
            return reader.readBoolean();
        }

        @Override
        public void toJson(JsonWriter writer, Boolean value) {
            writer.value(value);
        }

        public String toString() {
            return "JsonAdapter(Boolean)";
        }
    }

    static final class ByteAdapter
    implements JsonAdapter<Byte> {
        ByteAdapter() {
        }

        @Override
        public Byte fromJson(JsonReader reader) {
            return (byte)BasicTypeAdapters.rangeCheckNextInt(reader, "a byte", -128, 255);
        }

        @Override
        public void toJson(JsonWriter writer, Byte value) {
            writer.value((long)(value.intValue() & 0xFF));
        }

        public String toString() {
            return "JsonAdapter(Byte)";
        }
    }

    static final class CharacterAdapter
    implements JsonAdapter<Character> {
        CharacterAdapter() {
        }

        @Override
        public Character fromJson(JsonReader reader) {
            String value = reader.readString();
            if (value.length() > 1) {
                throw new JsonDataException(String.format("Expected %s but was %s at path %s", "a char", "\"" + value + "\"", reader.location()));
            }
            return Character.valueOf(value.charAt(0));
        }

        @Override
        public void toJson(JsonWriter writer, Character value) {
            writer.value(value.toString());
        }

        public String toString() {
            return "JsonAdapter(Character)";
        }
    }

    static final class DoubleAdapter
    implements JsonAdapter<Double> {
        DoubleAdapter() {
        }

        @Override
        public Double fromJson(JsonReader reader) {
            return reader.readDouble();
        }

        @Override
        public void toJson(JsonWriter writer, Double value) {
            writer.value(value);
        }

        public String toString() {
            return "JsonAdapter(Double)";
        }
    }

    static final class FloatAdapter
    implements JsonAdapter<Float> {
        FloatAdapter() {
        }

        @Override
        public Float fromJson(JsonReader reader) {
            float value = (float)reader.readDouble();
            if (Float.isInfinite(value)) {
                throw new JsonDataException("JSON forbids NaN and infinities: " + value + " at path " + reader.location());
            }
            return Float.valueOf(value);
        }

        @Override
        public void toJson(JsonWriter writer, Float value) {
            Objects.requireNonNull(value);
            writer.value(value.floatValue());
        }

        public String toString() {
            return "JsonAdapter(Float)";
        }
    }

    static final class IntegerAdapter
    implements JsonAdapter<Integer> {
        IntegerAdapter() {
        }

        @Override
        public Integer fromJson(JsonReader reader) {
            return reader.readInt();
        }

        @Override
        public void toJson(JsonWriter writer, Integer value) {
            writer.value(value);
        }

        public String toString() {
            return "JsonAdapter(Integer)";
        }
    }

    static final class LongAdapter
    implements JsonAdapter<Long> {
        LongAdapter() {
        }

        @Override
        public Long fromJson(JsonReader reader) {
            return reader.readLong();
        }

        @Override
        public void toJson(JsonWriter writer, Long value) {
            writer.value(value);
        }

        public String toString() {
            return "JsonAdapter(Long)";
        }
    }

    static final class ShortAdapter
    implements JsonAdapter<Short> {
        ShortAdapter() {
        }

        @Override
        public Short fromJson(JsonReader reader) {
            return (short)BasicTypeAdapters.rangeCheckNextInt(reader, "a short", Short.MIN_VALUE, Short.MAX_VALUE);
        }

        @Override
        public void toJson(JsonWriter writer, Short value) {
            writer.value((long)value.intValue());
        }

        public String toString() {
            return "JsonAdapter(Short)";
        }
    }

    static final class StringAdapter
    implements JsonAdapter<String> {
        StringAdapter() {
        }

        @Override
        public String fromJson(JsonReader reader) {
            return reader.readString();
        }

        @Override
        public void toJson(JsonWriter writer, String value) {
            writer.value(value);
        }

        public String toString() {
            return "JsonAdapter(String)";
        }
    }

    private static final class UuidAdapter
    implements JsonAdapter<UUID> {
        private UuidAdapter() {
        }

        @Override
        public UUID fromJson(JsonReader reader) {
            return UUID.fromString(reader.readString());
        }

        @Override
        public void toJson(JsonWriter writer, UUID value) {
            writer.value(value.toString());
        }

        public String toString() {
            return "JsonAdapter(UUID)";
        }
    }

    private static final class UrlAdapter
    implements JsonAdapter<URL> {
        private UrlAdapter() {
        }

        @Override
        public URL fromJson(JsonReader reader) {
            try {
                return new URI(reader.readString()).toURL();
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new JsonDataException(e);
            }
        }

        @Override
        public void toJson(JsonWriter writer, URL value) {
            writer.value(value.toString());
        }

        public String toString() {
            return "JsonAdapter(URL)";
        }
    }

    private static final class UriAdapter
    implements JsonAdapter<URI> {
        private UriAdapter() {
        }

        @Override
        public URI fromJson(JsonReader reader) {
            return URI.create(reader.readString());
        }

        @Override
        public void toJson(JsonWriter writer, URI value) {
            writer.value(value.toString());
        }

        public String toString() {
            return "JsonAdapter(URI)";
        }
    }

    private static final class InetAddressAdapter
    implements JsonAdapter<InetAddress> {
        private InetAddressAdapter() {
        }

        @Override
        public InetAddress fromJson(JsonReader reader) {
            try {
                return InetAddress.getByName(reader.readString());
            }
            catch (UnknownHostException e) {
                throw new JsonDataException(e);
            }
        }

        @Override
        public void toJson(JsonWriter writer, InetAddress value) {
            writer.value(value.getHostAddress());
        }

        public String toString() {
            return "JsonAdapter(InetAddress)";
        }
    }

    private static final class StackTraceElementAdapter
    implements JsonAdapter<StackTraceElement> {
        private StackTraceElementAdapter() {
        }

        @Override
        public StackTraceElement fromJson(JsonReader reader) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toJson(JsonWriter writer, StackTraceElement value) {
            writer.value(value.toString());
        }

        public String toString() {
            return "JsonAdapter(StackTraceElement)";
        }
    }

    static final class ObjectJsonAdapter
    implements JsonAdapter<Object> {
        private final Jsonb jsonb;
        private final JsonAdapter<List> listJsonAdapter;
        private final JsonAdapter<Map> mapAdapter;
        private final JsonAdapter<String> stringAdapter;
        private final JsonAdapter<Double> doubleAdapter;
        private final JsonAdapter<Boolean> booleanAdapter;

        ObjectJsonAdapter(Jsonb jsonb) {
            this.jsonb = jsonb;
            this.listJsonAdapter = jsonb.adapter(List.class);
            this.mapAdapter = jsonb.adapter(Map.class);
            this.stringAdapter = jsonb.adapter(String.class);
            this.doubleAdapter = jsonb.adapter(Double.class);
            this.booleanAdapter = jsonb.adapter(Boolean.class);
        }

        @Override
        public Object fromJson(JsonReader reader) {
            switch (reader.currentToken()) {
                case BEGIN_ARRAY: {
                    return this.listJsonAdapter.fromJson(reader);
                }
                case BEGIN_OBJECT: {
                    return this.mapAdapter.fromJson(reader);
                }
                case STRING: {
                    return this.stringAdapter.fromJson(reader);
                }
                case NUMBER: {
                    Double d = this.doubleAdapter.fromJson(reader);
                    if (d % 1.0 == 0.0) {
                        return d.longValue();
                    }
                    return d;
                }
                case BOOLEAN: {
                    return this.booleanAdapter.fromJson(reader);
                }
                case NULL: {
                    return null;
                }
            }
            throw new IllegalStateException("Expected a value but was " + String.valueOf((Object)reader.currentToken()) + " at path " + reader.location());
        }

        @Override
        public void toJson(JsonWriter writer, Object value) {
            Class<?> valueClass = value.getClass();
            if (valueClass == Object.class) {
                writer.beginObject();
                writer.endObject();
            } else if (value instanceof Optional) {
                Optional op = (Optional)value;
                op.ifPresentOrElse(v -> this.toJson(writer, v), writer::nullValue);
            } else {
                this.jsonb.adapter(this.toJsonType(valueClass)).toJson(writer, value);
            }
        }

        private Type toJsonType(Class<?> valueClass) {
            if (Map.class.isAssignableFrom(valueClass)) {
                return Map.class;
            }
            return Collection.class.isAssignableFrom(valueClass) ? Collection.class : valueClass;
        }

        public String toString() {
            return "JsonAdapter(Object)";
        }
    }

    private static final class ThrowableAdapter
    implements JsonAdapter<Throwable> {
        private static final int MAX_STACK = 5;
        private final JsonAdapter<StackTraceElement> stackTraceElementAdapter;

        private ThrowableAdapter(Jsonb jsonb) {
            this.stackTraceElementAdapter = jsonb.adapter(StackTraceElement.class);
        }

        @Override
        public Throwable fromJson(JsonReader reader) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toJson(JsonWriter writer, Throwable value) {
            Throwable[] suppressed;
            Throwable cause;
            writer.beginObject();
            writer.name("type");
            writer.value(value.getClass().toString());
            writer.name("message");
            writer.value(value.getMessage());
            StackTraceElement[] stackTrace = value.getStackTrace();
            if (stackTrace != null && stackTrace.length > 0) {
                int end = Math.min(5, stackTrace.length);
                List<StackTraceElement> stackTraceElements = Arrays.asList(stackTrace).subList(0, end);
                writer.name("stackTrace");
                writer.beginArray();
                for (StackTraceElement element : stackTraceElements) {
                    this.stackTraceElementAdapter.toJson(writer, element);
                }
                writer.endArray();
            }
            if ((cause = value.getCause()) != null) {
                writer.name("cause");
                this.toJson(writer, cause);
            }
            if ((suppressed = value.getSuppressed()) != null && suppressed.length > 0) {
                writer.name("suppressed");
                writer.beginArray();
                for (Throwable sup : suppressed) {
                    this.toJson(writer, sup);
                }
                writer.endArray();
            }
            writer.endObject();
        }

        public String toString() {
            return "JsonAdapter(URI)";
        }
    }

    static class EnumJsonAdapter<T extends Enum<T>>
    implements JsonAdapter<T> {
        protected final Class<T> enumType;

        EnumJsonAdapter(Class<T> enumType) {
            this.enumType = enumType;
        }

        @Override
        public T fromJson(JsonReader reader) {
            String value = reader.readString();
            return Enum.valueOf(this.enumType, value);
        }

        @Override
        public void toJson(JsonWriter writer, T value) {
            if (value != null) {
                writer.value(((Enum)value).name());
            } else {
                writer.value((String)null);
            }
        }

        protected final void throwException(Object value, String location) {
            throw new JsonDataException("Unable to determine enum value " + String.valueOf(this.enumType) + " value for " + String.valueOf(value) + " at " + location);
        }

        public String toString() {
            return "JsonAdapter(" + this.enumType.getName() + ")";
        }
    }
}

