/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.core;

import io.avaje.jsonb.JsonAdapter;
import io.avaje.jsonb.JsonReader;
import io.avaje.jsonb.JsonWriter;
import io.avaje.jsonb.Jsonb;
import io.avaje.jsonb.core.Util;
import io.avaje.jsonb.spi.ViewBuilder;
import io.avaje.jsonb.spi.ViewBuilderAware;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

abstract class CollectionAdapter<C extends Collection<T>, T>
implements JsonAdapter<C>,
ViewBuilderAware {
    static final JsonAdapter.Factory FACTORY = (type, jsonb) -> {
        Class<?> rawType = Util.rawType(type);
        if (rawType == List.class || rawType == Collection.class) {
            return CollectionAdapter.newListAdapter(type, jsonb).nullSafe();
        }
        if (rawType == Set.class) {
            return CollectionAdapter.newSetAdapter(type, jsonb).nullSafe();
        }
        return null;
    };
    private final JsonAdapter<T> elementAdapter;

    static <T> JsonAdapter<Collection<T>> newListAdapter(Type type, Jsonb jsonb) {
        Type elementType = Util.collectionElementType(type);
        JsonAdapter elementAdapter = jsonb.adapter(elementType);
        return new CollectionAdapter<Collection<T>, T>(elementAdapter){

            @Override
            Collection<T> newCollection() {
                return new ArrayList();
            }
        };
    }

    static <T> JsonAdapter<Set<T>> newSetAdapter(Type type, Jsonb jsonb) {
        Type elementType = Util.collectionElementType(type);
        JsonAdapter elementAdapter = jsonb.adapter(elementType);
        return new CollectionAdapter<Set<T>, T>(elementAdapter){

            @Override
            Set<T> newCollection() {
                return new LinkedHashSet();
            }
        };
    }

    private CollectionAdapter(JsonAdapter<T> elementAdapter) {
        this.elementAdapter = elementAdapter;
    }

    abstract C newCollection();

    @Override
    public boolean isViewBuilderAware() {
        return this.elementAdapter.isViewBuilderAware();
    }

    @Override
    public ViewBuilderAware viewBuild() {
        return this;
    }

    @Override
    public void build(ViewBuilder builder, String name, MethodHandle handle) {
        builder.addArray(name, this.elementAdapter, handle);
    }

    @Override
    public C fromJson(JsonReader reader) {
        C result = this.newCollection();
        reader.beginArray();
        while (reader.hasNextElement()) {
            result.add(this.elementAdapter.fromJson(reader));
        }
        reader.endArray();
        return result;
    }

    @Override
    public void toJson(JsonWriter writer, C value) {
        if (value.isEmpty()) {
            writer.emptyArray();
            return;
        }
        writer.beginArray();
        for (Object element : value) {
            this.elementAdapter.toJson(writer, element);
        }
        writer.endArray();
    }

    public String toString() {
        return String.valueOf(this.elementAdapter) + ".collection()";
    }
}

