/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.core;

import io.avaje.jsonb.core.ViewDslParser;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Set;

final class ViewDsl {
    private final Deque<Entry> stack = new ArrayDeque<Entry>();
    private Entry current;

    static ViewDsl parse(String dsl) {
        return new ViewDslParser().parse(dsl);
    }

    ViewDsl(Entry top) {
        this.current = top;
    }

    boolean contains(String id) {
        return this.current.contains(id);
    }

    void push(String key) {
        this.stack.push(this.current);
        Entry nested = this.current.nested(key);
        if (nested == null) {
            throw new IllegalStateException("nest property " + key + " not found?");
        }
        this.current = nested;
    }

    void pop() {
        this.current = this.stack.pop();
    }

    static final class Entry {
        private final Set<String> tokens;
        private final Map<String, Entry> children;
        private final boolean wildcard;

        Entry(Set<String> tokens, Map<String, Entry> children) {
            this.tokens = tokens;
            this.wildcard = tokens.contains("*");
            this.children = children;
        }

        boolean contains(String key) {
            return this.wildcard || this.tokens.contains(key);
        }

        Entry nested(String key) {
            return this.children.get(key);
        }
    }
}

