/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.stream;

import io.avaje.jsonb.JsonReader;
import io.avaje.jsonb.spi.PropertyNames;
import io.avaje.jsonb.stream.BufferRecycler;
import io.avaje.jsonb.stream.JsonNames;
import io.avaje.jsonb.stream.JsonParser;
import java.math.BigDecimal;
import java.math.BigInteger;

final class JsonReadAdapter
implements JsonReader {
    private final JsonParser reader;
    private final boolean failOnUnknown;
    private final BufferRecycler recycler;

    JsonReadAdapter(JsonParser reader, BufferRecycler recycler, boolean failOnUnknown) {
        this.reader = reader;
        this.failOnUnknown = failOnUnknown;
        this.recycler = recycler;
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        return type.cast(this.reader);
    }

    @Override
    public void beginStream() {
        this.reader.startStream();
    }

    @Override
    public void endStream() {
        this.reader.endStream();
    }

    @Override
    public void beginArray() {
        this.reader.startArray();
    }

    @Override
    public void endArray() {
        this.reader.endArray();
    }

    @Override
    public void beginObject(PropertyNames names) {
        this.reader.startObject((JsonNames)names);
    }

    @Override
    public void beginObject() {
        this.reader.startObject();
    }

    @Override
    public void endObject() {
        this.reader.endObject();
    }

    @Override
    public boolean hasNextElement() {
        return this.reader.hasNextElement();
    }

    @Override
    public boolean hasNextStreamElement() {
        return this.reader.hasNextStreamElement();
    }

    @Override
    public boolean hasNextField() {
        byte nextToken = this.reader.nextToken();
        if (nextToken == 34) {
            return true;
        }
        if (nextToken == 44) {
            return this.reader.nextToken() == 34;
        }
        return false;
    }

    @Override
    public String nextField() {
        return this.reader.nextField();
    }

    @Override
    public boolean readBoolean() {
        return this.reader.readBoolean();
    }

    @Override
    public int readInt() {
        return this.reader.readInt();
    }

    @Override
    public long readLong() {
        return this.reader.readLong();
    }

    @Override
    public double readDouble() {
        return this.reader.readDouble();
    }

    @Override
    public BigDecimal readDecimal() {
        return this.reader.readDecimal();
    }

    @Override
    public BigInteger readBigInteger() {
        return this.reader.readBigInteger();
    }

    @Override
    public String readString() {
        return this.reader.readString();
    }

    @Override
    public byte[] readBinary() {
        return this.reader.readBinary();
    }

    @Override
    public boolean isNullValue() {
        return this.reader.isNullValue();
    }

    @Override
    public String location() {
        return this.reader.location();
    }

    @Override
    public JsonReader.Token currentToken() {
        byte token = this.reader.currentToken();
        switch (token) {
            case 91: {
                return JsonReader.Token.BEGIN_ARRAY;
            }
            case 123: {
                return JsonReader.Token.BEGIN_OBJECT;
            }
            case 110: {
                return JsonReader.Token.NULL;
            }
            case 34: {
                return JsonReader.Token.STRING;
            }
            case 102: 
            case 116: {
                return JsonReader.Token.BOOLEAN;
            }
        }
        return JsonReader.Token.NUMBER;
    }

    @Override
    public void close() {
        this.reader.close();
        this.recycler.recycle(this.reader);
    }

    @Override
    public void skipValue() {
        this.reader.skipValue();
    }

    @Override
    public String readRaw() {
        return this.reader.readRaw();
    }

    @Override
    public void unmappedField(String fieldName) {
        if (this.failOnUnknown) {
            throw new IllegalStateException("Unknown property " + fieldName + " at " + this.reader.location());
        }
    }
}

