/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.core;

import io.avaje.json.JsonAdapter;
import io.avaje.json.JsonReader;
import io.avaje.json.JsonWriter;
import io.avaje.jsonb.AdapterFactory;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;

final class JavaTimeAdapters {
    static final AdapterFactory FACTORY = (type, jsonb) -> {
        if (type == Instant.class) {
            return INSTANT_ADAPTER.nullSafe();
        }
        if (type == LocalDate.class) {
            return LOCAL_DATE_ADAPTER.nullSafe();
        }
        if (type == LocalDateTime.class) {
            return LOCAL_DATE_TIME_ADAPTER.nullSafe();
        }
        if (type == LocalTime.class) {
            return LOCAL_TIME_ADAPTER.nullSafe();
        }
        if (type == MonthDay.class) {
            return MONTH_DAY_ADAPTER.nullSafe();
        }
        if (type == OffsetDateTime.class) {
            return OFFSET_DATE_TIME_ADAPTER.nullSafe();
        }
        if (type == OffsetTime.class) {
            return OFFSET_TIME_ADAPTER.nullSafe();
        }
        if (type == Period.class) {
            return PERIOD_ADAPTER.nullSafe();
        }
        if (type == Year.class) {
            return YEAR_ADAPTER.nullSafe();
        }
        if (type == YearMonth.class) {
            return YEAR_MONTH_ADAPTER.nullSafe();
        }
        if (type == ZonedDateTime.class) {
            return ZONED_DATE_TIME_ADAPTER.nullSafe();
        }
        if (type == ZoneId.class) {
            return ZONE_ID_ADAPTER.nullSafe();
        }
        if (type == ZoneOffset.class) {
            return ZONE_OFFSET_ADAPTER.nullSafe();
        }
        if (type == Date.class) {
            return UTIL_DATE.nullSafe();
        }
        if (type == Duration.class) {
            return DURATION_ADAPTER.nullSafe();
        }
        return null;
    };
    private static final JsonAdapter<Date> UTIL_DATE = new JsonAdapter<Date>(){

        public Date fromJson(JsonReader reader) {
            return Date.from(Instant.parse(reader.readString()));
        }

        public void toJson(JsonWriter writer, Date value) {
            writer.value(value.toInstant().toString());
        }

        public String toString() {
            return "JsonAdapter(Date)";
        }
    };
    private static final JsonAdapter<Duration> DURATION_ADAPTER = new JsonAdapter<Duration>(){

        public Duration fromJson(JsonReader reader) {
            return Duration.parse(reader.readString());
        }

        public void toJson(JsonWriter writer, Duration value) {
            writer.value(value.toString());
        }

        public String toString() {
            return "JsonAdapter(Duration)";
        }
    };
    private static final JsonAdapter<Instant> INSTANT_ADAPTER = new JsonAdapter<Instant>(){

        public Instant fromJson(JsonReader reader) {
            return Instant.parse(reader.readString());
        }

        public void toJson(JsonWriter writer, Instant value) {
            writer.value(value.toString());
        }

        public String toString() {
            return "JsonAdapter(Instant)";
        }
    };
    private static final JsonAdapter<OffsetDateTime> OFFSET_DATE_TIME_ADAPTER = new JsonAdapter<OffsetDateTime>(){

        public OffsetDateTime fromJson(JsonReader reader) {
            return OffsetDateTime.parse(reader.readString());
        }

        public void toJson(JsonWriter writer, OffsetDateTime value) {
            writer.value(value.toString());
        }

        public String toString() {
            return "JsonAdapter(OffsetDateTime)";
        }
    };
    private static final JsonAdapter<OffsetTime> OFFSET_TIME_ADAPTER = new JsonAdapter<OffsetTime>(){

        public OffsetTime fromJson(JsonReader reader) {
            return OffsetTime.parse(reader.readString());
        }

        public void toJson(JsonWriter writer, OffsetTime value) {
            writer.value(value.toString());
        }

        public String toString() {
            return "JsonAdapter(OffsetTime)";
        }
    };
    private static final JsonAdapter<ZonedDateTime> ZONED_DATE_TIME_ADAPTER = new JsonAdapter<ZonedDateTime>(){

        public ZonedDateTime fromJson(JsonReader reader) {
            return ZonedDateTime.parse(reader.readString());
        }

        public void toJson(JsonWriter writer, ZonedDateTime value) {
            writer.value(value.toString());
        }

        public String toString() {
            return "JsonAdapter(ZonedDateTime)";
        }
    };
    private static final JsonAdapter<ZoneOffset> ZONE_OFFSET_ADAPTER = new JsonAdapter<ZoneOffset>(){

        public ZoneOffset fromJson(JsonReader reader) {
            return ZoneOffset.of(reader.readString());
        }

        public void toJson(JsonWriter writer, ZoneOffset value) {
            writer.value(value.toString());
        }

        public String toString() {
            return "JsonAdapter(ZoneOffset)";
        }
    };
    private static final JsonAdapter<ZoneId> ZONE_ID_ADAPTER = new JsonAdapter<ZoneId>(){

        public ZoneId fromJson(JsonReader reader) {
            return ZoneId.of(reader.readString());
        }

        public void toJson(JsonWriter writer, ZoneId value) {
            writer.value(value.toString());
        }

        public String toString() {
            return "JsonAdapter(ZoneOffset)";
        }
    };
    private static final JsonAdapter<LocalDate> LOCAL_DATE_ADAPTER = new JsonAdapter<LocalDate>(){

        public LocalDate fromJson(JsonReader reader) {
            return LocalDate.parse(reader.readString());
        }

        public void toJson(JsonWriter writer, LocalDate value) {
            writer.value(value.toString());
        }

        public String toString() {
            return "JsonAdapter(LocalDate)";
        }
    };
    private static final JsonAdapter<LocalDateTime> LOCAL_DATE_TIME_ADAPTER = new JsonAdapter<LocalDateTime>(){

        public LocalDateTime fromJson(JsonReader reader) {
            return LocalDateTime.parse(reader.readString());
        }

        public void toJson(JsonWriter writer, LocalDateTime value) {
            writer.value(value.toString());
        }

        public String toString() {
            return "JsonAdapter(LocalDateTime)";
        }
    };
    private static final JsonAdapter<LocalTime> LOCAL_TIME_ADAPTER = new JsonAdapter<LocalTime>(){

        public LocalTime fromJson(JsonReader reader) {
            return LocalTime.parse(reader.readString());
        }

        public void toJson(JsonWriter writer, LocalTime value) {
            writer.value(value.toString());
        }

        public String toString() {
            return "JsonAdapter(LocalTime)";
        }
    };
    private static final JsonAdapter<MonthDay> MONTH_DAY_ADAPTER = new JsonAdapter<MonthDay>(){

        public MonthDay fromJson(JsonReader reader) {
            return MonthDay.parse(reader.readString());
        }

        public void toJson(JsonWriter writer, MonthDay value) {
            writer.value(value.toString());
        }

        public String toString() {
            return "JsonAdapter(MonthDay)";
        }
    };
    private static final JsonAdapter<Period> PERIOD_ADAPTER = new JsonAdapter<Period>(){

        public Period fromJson(JsonReader reader) {
            return Period.parse(reader.readString());
        }

        public void toJson(JsonWriter writer, Period value) {
            writer.value(value.toString());
        }

        public String toString() {
            return "JsonAdapter(Period)";
        }
    };
    private static final JsonAdapter<Year> YEAR_ADAPTER = new JsonAdapter<Year>(){

        public Year fromJson(JsonReader reader) {
            return Year.of(reader.readInt());
        }

        public void toJson(JsonWriter writer, Year value) {
            writer.value(value.getValue());
        }

        public String toString() {
            return "JsonAdapter(Year)";
        }
    };
    private static final JsonAdapter<YearMonth> YEAR_MONTH_ADAPTER = new JsonAdapter<YearMonth>(){

        public YearMonth fromJson(JsonReader reader) {
            return YearMonth.parse(reader.readString());
        }

        public void toJson(JsonWriter writer, YearMonth value) {
            writer.value(value.toString());
        }

        public String toString() {
            return "JsonAdapter(YearMonth)";
        }
    };

    JavaTimeAdapters() {
    }
}

