/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.core;

import io.avaje.json.JsonAdapter;
import io.avaje.json.JsonReader;
import io.avaje.json.JsonWriter;
import io.avaje.json.view.ViewBuilderAware;
import io.avaje.jsonb.AdapterFactory;
import io.avaje.jsonb.Jsonb;
import io.avaje.jsonb.Types;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

final class OptionalAdapters {
    static final AdapterFactory FACTORY = (type, jsonb) -> {
        if (Types.isGenericTypeOf(type, Optional.class)) {
            Type[] args = Types.typeArguments(type);
            return new OptionalAdapter(jsonb, args[0]).nullSafe();
        }
        if (type == OptionalInt.class) {
            return new OptionalIntAdapter().nullSafe();
        }
        if (type == OptionalDouble.class) {
            return new OptionalDoubleAdapter().nullSafe();
        }
        if (type == OptionalLong.class) {
            return new OptionalLongAdapter().nullSafe();
        }
        return null;
    };

    private OptionalAdapters() {
    }

    static final class OptionalAdapter<T>
    implements JsonAdapter<Optional<T>> {
        private final JsonAdapter<T> delegate;

        OptionalAdapter(Jsonb jsonb, Type param0) {
            this.delegate = jsonb.adapter(param0);
        }

        public void toJson(JsonWriter writer, Optional<T> value) {
            this.delegate.toJson(writer, value.orElse(null));
        }

        public Optional<T> fromJson(JsonReader reader) {
            return Optional.ofNullable(this.delegate.fromJson(reader));
        }

        public boolean isViewBuilderAware() {
            return this.delegate.isViewBuilderAware();
        }

        public ViewBuilderAware viewBuild() {
            return this.delegate.viewBuild();
        }

        public String toString() {
            return String.valueOf(this.delegate) + ".optional()";
        }
    }

    static final class OptionalIntAdapter
    implements JsonAdapter<OptionalInt> {
        OptionalIntAdapter() {
        }

        public OptionalInt fromJson(JsonReader reader) {
            return OptionalInt.of(reader.readInt());
        }

        public void toJson(JsonWriter writer, OptionalInt value) {
            value.ifPresentOrElse(arg_0 -> ((JsonWriter)writer).value(arg_0), () -> ((JsonWriter)writer).nullValue());
        }

        public String toString() {
            return "JsonAdapter(OptionalInt)";
        }
    }

    static final class OptionalDoubleAdapter
    implements JsonAdapter<OptionalDouble> {
        OptionalDoubleAdapter() {
        }

        public OptionalDouble fromJson(JsonReader reader) {
            return OptionalDouble.of(reader.readDouble());
        }

        public void toJson(JsonWriter writer, OptionalDouble value) {
            value.ifPresentOrElse(arg_0 -> ((JsonWriter)writer).value(arg_0), () -> ((JsonWriter)writer).nullValue());
        }

        public String toString() {
            return "JsonAdapter(OptionalDouble)";
        }
    }

    static final class OptionalLongAdapter
    implements JsonAdapter<OptionalLong> {
        OptionalLongAdapter() {
        }

        public OptionalLong fromJson(JsonReader reader) {
            return OptionalLong.of(reader.readLong());
        }

        public void toJson(JsonWriter writer, OptionalLong value) {
            value.ifPresentOrElse(arg_0 -> ((JsonWriter)writer).value(arg_0), () -> ((JsonWriter)writer).nullValue());
        }

        public String toString() {
            return "JsonAdapter(OptionalLong)";
        }
    }
}

