/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.core;

import io.avaje.json.JsonAdapter;
import io.avaje.json.JsonException;
import io.avaje.json.JsonIoException;
import io.avaje.json.JsonWriter;
import io.avaje.json.PropertyNames;
import io.avaje.json.stream.BufferedJsonWriter;
import io.avaje.json.stream.BytesJsonWriter;
import io.avaje.json.stream.JsonOutput;
import io.avaje.json.view.ViewBuilder;
import io.avaje.jsonb.JsonView;
import io.avaje.jsonb.core.DJsonb;
import io.avaje.jsonb.core.ViewDsl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;

final class CoreViewBuilder
implements ViewBuilder {
    private final MethodHandles.Lookup lookup = MethodHandles.lookup();
    private final Deque<Items> stack = new ArrayDeque<Items>();
    private final ViewDsl viewDsl;
    private final Names names;
    private Items current;
    private Element resultElement;

    CoreViewBuilder(ViewDsl viewDsl) {
        this.viewDsl = viewDsl;
        this.names = new Names();
    }

    private CoreViewBuilder(ViewDsl viewDsl, Names names) {
        this.viewDsl = viewDsl;
        this.names = names;
    }

    public MethodHandle method(Class<?> cls, String methodName, Class<?> returnType) {
        try {
            return this.lookup.findVirtual(cls, methodName, MethodType.methodType(returnType));
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public MethodHandle field(Class<?> cls, String name) {
        try {
            Field field = cls.getDeclaredField(name);
            return this.lookup.unreflectGetter(field);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    private void push(String name, MethodHandle mh) {
        this.current = new Items(this.names, name, mh);
        this.stack.push(this.current);
    }

    private void pop() {
        Items items = this.stack.pop();
        Element element = items.build();
        if (this.stack.isEmpty()) {
            this.resultElement = element;
        } else {
            this.current = this.stack.peek();
            this.current.add(element);
        }
    }

    public void add(String name, JsonAdapter<?> adapter, MethodHandle methodHandle) {
        if (this.viewDsl.contains(name)) {
            if (adapter.isViewBuilderAware()) {
                this.viewDsl.push(name);
                adapter.viewBuild().build((ViewBuilder)this, name, methodHandle);
                this.viewDsl.pop();
            } else {
                this.current.add(new Scalar(this.names.add(name), adapter, methodHandle));
            }
        }
    }

    public void beginObject(String name, MethodHandle methodHandle) {
        this.push(name, methodHandle);
    }

    public void endObject() {
        this.pop();
    }

    public void addArray(String name, JsonAdapter<?> adapter, MethodHandle methodHandle) {
        try {
            CoreViewBuilder nested = new CoreViewBuilder(this.viewDsl, this.names);
            adapter.viewBuild().build((ViewBuilder)nested);
            JsonView nestedView = nested.build();
            if (name == null) {
                if (this.current != null) {
                    throw new IllegalStateException();
                }
                this.resultElement = new CollectionElement(nestedView);
            } else {
                this.current.add(new NestedCollection(nestedView, this.names.add(name), methodHandle));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    <T> JsonView<T> build(DJsonb jsonb) {
        return new DView(jsonb, this.resultElement, jsonb.properties(this.names.properties()));
    }

    <T> JsonView<T> build() {
        return new DView(this.resultElement);
    }

    static final class Names {
        private final List<String> names = new ArrayList<String>();
        private int namePosition = -1;

        Names() {
        }

        int add(String name) {
            this.names.add(name);
            return ++this.namePosition;
        }

        String[] properties() {
            return this.names.toArray(new String[0]);
        }
    }

    static final class Items {
        private final Names names;
        private final String name;
        private final MethodHandle methodHandle;
        private final List<Element> items = new ArrayList<Element>();

        Items(Names names, String name, MethodHandle mh) {
            this.names = names;
            this.name = name;
            this.methodHandle = mh;
        }

        void add(Element element) {
            this.items.add(element);
        }

        Element build() {
            if (this.name == null) {
                return new ObjectElement(this.items);
            }
            return new NestedObject(this.items, this.names.add(this.name), this.methodHandle);
        }
    }

    static interface Element {
        public void write(JsonWriter var1, Object var2) throws IOException;
    }

    private static final class Scalar
    implements Element {
        private final int namePosition;
        private final JsonAdapter adapter;
        private final MethodHandle methodHandle;

        Scalar(int namePosition, JsonAdapter adapter, MethodHandle methodHandle) {
            this.namePosition = namePosition;
            this.adapter = adapter;
            this.methodHandle = methodHandle;
        }

        @Override
        public void write(JsonWriter writer, Object object) {
            try {
                writer.name(this.namePosition);
                this.adapter.toJson(writer, this.methodHandle.invoke(object));
            }
            catch (Throwable e) {
                throw JsonException.of((Throwable)e);
            }
        }
    }

    private static final class CollectionElement
    implements Element {
        private final JsonView child;

        CollectionElement(JsonView child) {
            this.child = child;
        }

        @Override
        public void write(JsonWriter writer, Object object) {
            Collection collection = (Collection)object;
            if (collection.isEmpty()) {
                writer.emptyArray();
            } else {
                writer.beginArray();
                for (Object value : collection) {
                    this.child.toJson(value, writer);
                }
                writer.endArray();
            }
        }
    }

    private static final class NestedCollection
    implements Element {
        private final JsonView child;
        private final int namePosition;
        private final MethodHandle methodHandle;

        NestedCollection(JsonView child, int namePosition, MethodHandle methodHandle) {
            this.child = child;
            this.namePosition = namePosition;
            this.methodHandle = methodHandle;
        }

        @Override
        public void write(JsonWriter writer, Object object) {
            try {
                writer.name(this.namePosition);
                Collection collection = this.methodHandle.invoke(object);
                if (collection.isEmpty()) {
                    writer.emptyArray();
                } else {
                    writer.beginArray();
                    for (Object value : collection) {
                        this.child.toJson(value, writer);
                    }
                    writer.endArray();
                }
            }
            catch (Throwable e) {
                throw JsonException.of((Throwable)e);
            }
        }
    }

    private static final class DView<T>
    implements JsonView<T> {
        private final DJsonb jsonb;
        private final PropertyNames properties;
        private final Element element;

        DView(DJsonb jsonb, Element element, PropertyNames properties) {
            this.jsonb = jsonb;
            this.element = element;
            this.properties = properties;
        }

        DView(Element element) {
            this.element = element;
            this.jsonb = null;
            this.properties = null;
        }

        @Override
        public String toJson(T value) {
            try (BufferedJsonWriter writer = this.jsonb.bufferedWriter();){
                this.toJson(value, (JsonWriter)writer);
                String string = writer.result();
                return string;
            }
        }

        @Override
        public String toJsonPretty(T value) {
            try (BufferedJsonWriter writer = this.jsonb.bufferedWriter();){
                writer.pretty(true);
                this.toJson(value, (JsonWriter)writer);
                String string = writer.result();
                return string;
            }
        }

        @Override
        public byte[] toJsonBytes(T value) {
            try (BytesJsonWriter writer = this.jsonb.bufferedWriterAsBytes();){
                this.toJson(value, (JsonWriter)writer);
                byte[] byArray = writer.result();
                return byArray;
            }
        }

        @Override
        public void toJson(T value, JsonWriter writer) {
            if (this.properties != null) {
                writer.allNames(this.properties);
            }
            try {
                this.element.write(writer, value);
            }
            catch (IOException e) {
                throw new JsonIoException(e);
            }
        }

        @Override
        public void toJson(T value, Writer writer) {
            try (JsonWriter jsonWriter = this.jsonb.writer(writer);){
                this.toJson(value, jsonWriter);
            }
        }

        @Override
        public void toJson(T value, OutputStream outputStream) {
            try (JsonWriter writer = this.jsonb.writer(outputStream);){
                this.toJson(value, writer);
            }
        }

        @Override
        public void toJson(T value, JsonOutput output) {
            try (JsonWriter writer = this.jsonb.writer(output);){
                this.toJson(value, writer);
            }
        }
    }

    private static final class NestedObject
    implements Element {
        private final int namePosition;
        private final MethodHandle methodHandle;
        private final Element[] elements;

        NestedObject(List<Element> elements, int namePosition, MethodHandle methodHandle) {
            this.namePosition = namePosition;
            this.methodHandle = methodHandle;
            this.elements = elements.toArray(new Element[0]);
        }

        @Override
        public void write(JsonWriter writer, Object object) {
            try {
                writer.name(this.namePosition);
                writer.beginObject();
                Object nested = this.methodHandle.invoke(object);
                for (Element element : this.elements) {
                    element.write(writer, nested);
                }
                writer.endObject();
            }
            catch (Throwable e) {
                throw JsonException.of((Throwable)e);
            }
        }
    }

    private static final class ObjectElement
    implements Element {
        private final Element[] elements;

        ObjectElement(List<Element> elements) {
            this.elements = elements.toArray(new Element[0]);
        }

        @Override
        public void write(JsonWriter writer, Object object) {
            try {
                writer.beginObject();
                for (Element element : this.elements) {
                    element.write(writer, object);
                }
                writer.endObject();
            }
            catch (IOException e) {
                throw new JsonIoException(e);
            }
        }
    }
}

