/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.core;

import io.avaje.json.JsonAdapter;
import io.avaje.json.JsonException;
import io.avaje.json.JsonReader;
import io.avaje.json.JsonWriter;
import io.avaje.json.stream.BufferedJsonWriter;
import io.avaje.json.stream.BytesJsonWriter;
import io.avaje.json.stream.JsonOutput;
import io.avaje.jsonb.JsonType;
import io.avaje.jsonb.JsonView;
import io.avaje.jsonb.Types;
import io.avaje.jsonb.core.DJsonStreamType;
import io.avaje.jsonb.core.DJsonb;
import io.avaje.jsonb.core.StreamAdapter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

class DJsonType<T>
implements JsonType<T> {
    protected final DJsonb jsonb;
    protected final Type type;
    protected final JsonAdapter<T> adapter;

    DJsonType(DJsonb jsonb, Type type, JsonAdapter<T> adapter) {
        this.jsonb = jsonb;
        this.type = type;
        this.adapter = adapter;
    }

    @Override
    public final JsonView<T> view(String dsl) {
        return this.jsonb.buildView(dsl, this.adapter, this.type);
    }

    @Override
    public JsonType<Stream<T>> stream() {
        return new DJsonStreamType<Stream<T>>(this.jsonb, Types.newParameterizedType(Stream.class, new Type[]{this.type}), new StreamAdapter<T>(this.adapter));
    }

    @Override
    public final JsonType<List<T>> list() {
        return this.jsonb.type(Types.listOf(this.type));
    }

    @Override
    public final JsonType<Set<T>> set() {
        return this.jsonb.type(Types.setOf(this.type));
    }

    @Override
    public final JsonType<Map<String, T>> map() {
        return this.jsonb.type(Types.mapOf(this.type));
    }

    @Override
    public final JsonType<Optional<T>> optional() {
        return this.jsonb.type(Types.optionalOf(this.type));
    }

    @Override
    public final String toJson(T value) {
        try (BufferedJsonWriter writer = this.jsonb.bufferedWriter();){
            this.toJson(value, (JsonWriter)writer);
            String string = writer.result();
            return string;
        }
    }

    @Override
    public final String toJsonPretty(T value) {
        try (BufferedJsonWriter writer = this.jsonb.bufferedWriter();){
            writer.pretty(true);
            this.toJson(value, (JsonWriter)writer);
            String string = writer.result();
            return string;
        }
    }

    @Override
    public final byte[] toJsonBytes(T value) {
        try (BytesJsonWriter writer = this.jsonb.bufferedWriterAsBytes();){
            this.toJson(value, (JsonWriter)writer);
            byte[] byArray = writer.result();
            return byArray;
        }
    }

    @Override
    public final void toJson(T value, JsonWriter writer) {
        try {
            this.adapter.toJson(writer, value);
        }
        catch (RuntimeException e) {
            writer.markIncomplete();
            throw new JsonException((Throwable)e);
        }
    }

    @Override
    public final void toJson(T value, Writer writer) {
        try (JsonWriter jsonWriter = this.jsonb.writer(writer);){
            this.toJson(value, jsonWriter);
        }
    }

    @Override
    public final void toJson(T value, OutputStream outputStream) {
        try (JsonWriter writer = this.jsonb.writer(outputStream);){
            this.toJson(value, writer);
        }
        this.close(outputStream);
    }

    @Override
    public final void toJson(T value, JsonOutput output) {
        try (JsonWriter writer = this.jsonb.writer(output);){
            this.toJson(value, writer);
        }
        this.close((Closeable)output);
    }

    private void close(Closeable outputStream) {
        try {
            outputStream.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error closing stream", e);
        }
    }

    @Override
    public final Stream<T> stream(JsonReader reader) {
        return new StreamAdapter<T>(this.adapter).fromJson(reader);
    }

    @Override
    public final T fromObject(Object value) {
        try (JsonReader reader = this.jsonb.objectReader(value);){
            Object object = this.adapter.fromJson(reader);
            return (T)object;
        }
    }

    @Override
    public final T fromJson(JsonReader reader) {
        return (T)this.adapter.fromJson(reader);
    }

    @Override
    public T fromJson(String content) {
        try (JsonReader reader = this.jsonb.reader(content);){
            Object object = this.adapter.fromJson(reader);
            return (T)object;
        }
    }

    @Override
    public T fromJson(byte[] content) {
        try (JsonReader reader = this.jsonb.reader(content);){
            Object object = this.adapter.fromJson(reader);
            return (T)object;
        }
    }

    @Override
    public T fromJson(Reader content) {
        try (JsonReader reader = this.jsonb.reader(content);){
            Object object = this.adapter.fromJson(reader);
            return (T)object;
        }
    }

    @Override
    public T fromJson(InputStream inputStream) {
        try (JsonReader reader = this.jsonb.reader(inputStream);){
            Object object = this.adapter.fromJson(reader);
            return (T)object;
        }
    }
}

