/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb;

import io.avaje.jsonb.core.Util;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public final class Types {
    private Types() {
    }

    public static <T> Collection<T> nullToEmpty(Collection<T> source) {
        return source == null ? Collections.emptyList() : source;
    }

    public static GenericArrayType arrayOf(Type elementType) {
        return Util.arrayOf(elementType);
    }

    public static ParameterizedType listOf(Type elementType) {
        return Types.newParameterizedType(List.class, new Type[]{elementType});
    }

    public static ParameterizedType setOf(Type elementType) {
        return Types.newParameterizedType(Set.class, new Type[]{elementType});
    }

    public static ParameterizedType streamOf(Type elementType) {
        return Types.newParameterizedType(Stream.class, new Type[]{elementType});
    }

    public static ParameterizedType mapOf(Type valueElementType) {
        return Types.newParameterizedType(Map.class, new Type[]{String.class, valueElementType});
    }

    public static ParameterizedType optionalOf(Type valueElementType) {
        return Types.newParameterizedType(Optional.class, new Type[]{valueElementType});
    }

    public static ParameterizedType newParameterizedType(Type rawType, Type ... typeArguments) {
        return Util.newParameterizedType(rawType, typeArguments);
    }

    public static Class<?> rawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return Array.newInstance(Types.rawType(componentType), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return Object.class;
        }
        if (type instanceof WildcardType) {
            return Types.rawType(((WildcardType)type).getUpperBounds()[0]);
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or  GenericArrayType, but <" + String.valueOf(type) + "> is of type " + className);
    }

    public static Type[] typeArguments(Type type) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments();
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected ParameterizedType but <" + String.valueOf(type) + "> is of type " + className);
    }

    public static boolean isGenericTypeOf(Type jsonType, Class<?> adapterClass) {
        return (jsonType instanceof GenericArrayType || jsonType instanceof ParameterizedType) && Types.rawType(jsonType) == adapterClass;
    }
}

