/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.core;

import io.avaje.json.JsonAdapter;
import io.avaje.json.core.CoreTypes;
import io.avaje.jsonb.AdapterFactory;
import io.avaje.jsonb.Jsonb;
import io.avaje.jsonb.core.Util;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class CoreAdapters {
    static final AdapterFactory FACTORY = (type, jsonb) -> CoreTypes.create((Type)type);
    static final AdapterFactory ARRAY_FACTORY = (type, jsonb) -> {
        Type elementType = Util.arrayComponentType(type);
        if (elementType == null) {
            return null;
        }
        if (elementType == Byte.TYPE) {
            return CoreTypes.byteArray();
        }
        Class<?> elementClass = Util.rawType(elementType);
        JsonAdapter elementAdapter = jsonb.adapter(elementType);
        return CoreTypes.createArray(elementClass, elementAdapter).nullSafe();
    };
    static final AdapterFactory MAP_FACTORY = (type, jsonb) -> {
        Class<?> rawType = Util.rawType(type);
        if (rawType != Map.class) {
            return null;
        }
        Type[] valueTypes = Util.mapValueTypes(type, rawType);
        if (valueTypes[0] != String.class) {
            return null;
        }
        JsonAdapter valueAdapter = jsonb.adapter(valueTypes[1]);
        return CoreTypes.createMap(valueAdapter);
    };
    static final AdapterFactory COLLECTION_FACTORY = (type, jsonb) -> {
        Class<?> rawType = Util.rawType(type);
        if (rawType == List.class || rawType == Collection.class) {
            return CoreAdapters.newListAdapter(type, jsonb).nullSafe();
        }
        if (rawType == Set.class) {
            return CoreAdapters.newSetAdapter(type, jsonb).nullSafe();
        }
        return null;
    };

    CoreAdapters() {
    }

    private static <T> JsonAdapter<List<T>> newListAdapter(Type type, Jsonb jsonb) {
        Type elementType = Util.collectionElementType(type);
        JsonAdapter elementAdapter = jsonb.adapter(elementType);
        return CoreTypes.createList(elementAdapter);
    }

    private static <T> JsonAdapter<Set<T>> newSetAdapter(Type type, Jsonb jsonb) {
        Type elementType = Util.collectionElementType(type);
        JsonAdapter elementAdapter = jsonb.adapter(elementType);
        return CoreTypes.createSet(elementAdapter);
    }
}

