/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.core;

import io.avaje.json.JsonAdapter;
import io.avaje.json.JsonDataException;
import io.avaje.json.JsonReader;
import io.avaje.json.JsonWriter;
import io.avaje.jsonb.AdapterFactory;
import io.avaje.jsonb.Jsonb;
import io.avaje.jsonb.core.Util;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.Map;

final class EnumMapAdapter<K extends Enum<K>, V>
implements JsonAdapter<Map<K, V>> {
    static final AdapterFactory FACTORY = (type, jsonb) -> {
        Class<?> rawType = Util.rawType(type);
        if (rawType != EnumMap.class && rawType != Map.class) {
            return null;
        }
        Type[] types = Util.mapValueTypes(type, rawType);
        if (!((Class)types[0]).isEnum()) {
            return null;
        }
        return new EnumMapAdapter(jsonb, types).nullSafe();
    };
    private final Class<K> enumClass;
    private final JsonAdapter<V> valueAdapter;

    EnumMapAdapter(Jsonb jsonb, Type[] valueType) {
        this.enumClass = (Class)valueType[0];
        this.valueAdapter = jsonb.adapter(valueType[1]);
    }

    public void toJson(JsonWriter writer, Map<K, V> map) {
        writer.beginObject();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (entry.getKey() == null) {
                throw new JsonDataException("Map key is null at " + writer.path());
            }
            writer.name(((Enum)entry.getKey()).name());
            this.valueAdapter.toJson(writer, entry.getValue());
        }
        writer.endObject();
    }

    public Map<K, V> fromJson(JsonReader reader) {
        EnumMap<K, Object> result = new EnumMap<K, Object>(this.enumClass);
        reader.beginObject();
        while (reader.hasNextField()) {
            Object value;
            String name = reader.nextField();
            K enumVal = Enum.valueOf(this.enumClass, name);
            Object replaced = result.put(enumVal, value = this.valueAdapter.fromJson(reader));
            if (replaced == null) continue;
            throw new JsonDataException(String.format("Map key '%s' has multiple values at path %s : %s and %s", name, reader.location(), replaced, value));
        }
        reader.endObject();
        return result;
    }

    public String toString() {
        return "EnumMapAdapter(" + String.valueOf(this.enumClass) + ", " + String.valueOf(this.valueAdapter) + ")";
    }
}

