/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.core;

import io.avaje.json.JsonReader;
import io.avaje.json.PropertyNames;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

final class ObjectJsonReader
implements JsonReader {
    private final Object source;
    private Object currentValue;
    private Iterator<?> collectionIterator;
    private Iterator<Map.Entry<String, Object>> mapIterator;

    ObjectJsonReader(Object source) {
        this.source = source;
        this.currentValue = source;
    }

    public <T> T unwrap(Class<T> type) {
        throw new UnsupportedOperationException();
    }

    public void unmappedField(String fieldName) {
    }

    public void close() {
    }

    public void skipValue() {
    }

    public void beginArray() {
        this.collectionIterator = ((Collection)this.currentValue).iterator();
    }

    public void endArray() {
    }

    public boolean hasNextElement() {
        if (this.collectionIterator.hasNext()) {
            this.currentValue = this.collectionIterator.next();
            return true;
        }
        return false;
    }

    public void beginObject() {
        Map map = (Map)this.currentValue;
        this.mapIterator = map.entrySet().iterator();
    }

    public void beginObject(PropertyNames names) {
        this.beginObject();
    }

    public void endObject() {
    }

    public boolean hasNextField() {
        return this.mapIterator.hasNext();
    }

    public String nextField() {
        Map.Entry<String, Object> mapEntry = this.mapIterator.next();
        this.currentValue = mapEntry.getValue();
        return mapEntry.getKey();
    }

    public boolean readBoolean() {
        if (this.currentValue instanceof Boolean) {
            return (Boolean)this.currentValue;
        }
        return Boolean.parseBoolean(this.currentValue.toString());
    }

    public int readInt() {
        if (this.currentValue instanceof Integer) {
            return (Integer)this.currentValue;
        }
        return Integer.parseInt(this.currentValue.toString());
    }

    public long readLong() {
        if (this.currentValue instanceof Long) {
            return (Long)this.currentValue;
        }
        return Long.parseLong(this.currentValue.toString());
    }

    public double readDouble() {
        if (this.currentValue instanceof Double) {
            return (Double)this.currentValue;
        }
        return Double.parseDouble(this.currentValue.toString());
    }

    public String readString() {
        if (this.currentValue instanceof String) {
            return (String)this.currentValue;
        }
        return this.currentValue.toString();
    }

    public String readRaw() {
        return this.readString();
    }

    public BigDecimal readDecimal() {
        if (this.currentValue instanceof BigDecimal) {
            return (BigDecimal)this.currentValue;
        }
        return new BigDecimal(this.currentValue.toString());
    }

    public BigInteger readBigInteger() {
        if (this.currentValue instanceof BigInteger) {
            return (BigInteger)this.currentValue;
        }
        return new BigInteger(this.currentValue.toString());
    }

    public byte[] readBinary() {
        return (byte[])this.currentValue;
    }

    public boolean isNullValue() {
        return this.currentValue == null;
    }

    public String location() {
        return "unknown";
    }

    public JsonReader.Token currentToken() {
        throw new IllegalStateException("not called");
    }

    public String toString() {
        return String.valueOf(this.source);
    }
}

