/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.prism.internal;

import io.avaje.prism.internal.APContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

final class ServiceWriter {
    private static final Set<String> services = new HashSet<String>();
    private static final String PROCESSOR = "javax.annotation.processing.Processor";

    ServiceWriter() {
    }

    static void addProcessor(TypeElement e) {
        services.add(e.getQualifiedName().toString());
    }

    static void write() {
        if (services.isEmpty()) {
            return;
        }
        Filer filer = APContext.filer();
        try {
            APContext.logNote("Writing META-INF/services/%s", PROCESSOR);
            FileObject f = filer.createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/javax.annotation.processing.Processor", new Element[0]);
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(f.openOutputStream(), "UTF-8"));
            for (String value : services) {
                pw.println(value);
            }
            pw.close();
        }
        catch (IOException x) {
            APContext.logError("Failed to write service definition files: %s", x);
        }
        ServiceWriter.validateModules();
    }

    private static void validateModules() {
        ModuleElement module = APContext.getProjectModuleElement();
        if (module != null && !module.isUnnamed()) {
            try (BufferedReader reader = APContext.getModuleInfoReader();){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.isBlank()) continue;
                    if (line.contains("io.avaje.prism") && !line.contains("static")) {
                        APContext.logWarn(module, "`requires io.avaje.prism` should be `requires static io.avaje.prism;`", new Object[0]);
                    }
                    if (!line.contains("io.avaje.prism.core")) continue;
                    APContext.logWarn(module, "io.avaje.prism.core should be not be used directly", new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        services.clear();
    }
}

