/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.prism.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

final class GeneratePrismPrism {
    private final TypeMirror _value;
    private final String _name;
    private final Boolean _publicAccess;
    private final TypeMirror _superClass;
    private final List<TypeMirror> _superInterfaces;
    public static final String PRISM_TYPE = "io.avaje.prism.GeneratePrism";
    final boolean isValid;
    final AnnotationMirror mirror;
    private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
    private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
    private boolean valid = true;

    static boolean isPresent(Element element) {
        return GeneratePrismPrism.getInstanceOn(element) != null;
    }

    static GeneratePrismPrism getInstanceOn(Element element) {
        AnnotationMirror mirror = GeneratePrismPrism.getMirror(element);
        if (mirror == null) {
            return null;
        }
        return GeneratePrismPrism.getInstance(mirror);
    }

    static List<GeneratePrismPrism> getAllInstancesOn(Element element) {
        return GeneratePrismPrism.getMirrors(element).map(GeneratePrismPrism::getInstance).collect(Collectors.toList());
    }

    static GeneratePrismPrism getInstance(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return null;
        }
        return new GeneratePrismPrism(mirror);
    }

    private GeneratePrismPrism(AnnotationMirror mirror) {
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
        }
        this._value = this.getValue("value", TypeMirror.class);
        this._name = this.getValue("name", String.class);
        this._publicAccess = this.getValue("publicAccess", Boolean.class);
        this._superClass = this.getValue("superClass", TypeMirror.class);
        this._superInterfaces = this.getArrayValues("superInterfaces", TypeMirror.class);
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    TypeMirror value() {
        return this._value;
    }

    String name() {
        return this._name;
    }

    Boolean publicAccess() {
        return this._publicAccess;
    }

    TypeMirror superClass() {
        return this._superClass;
    }

    List<TypeMirror> superInterfaces() {
        return this._superInterfaces;
    }

    private <T> T getValue(String name, Class<T> clazz) {
        T result = GeneratePrismPrism.getValue(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private <T> List<T> getArrayValues(String name, Class<T> clazz) {
        List<T> result = GeneratePrismPrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private static AnnotationMirror getMirror(Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!PRISM_TYPE.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static Stream<? extends AnnotationMirror> getMirrors(Element target) {
        return target.getAnnotationMirrors().stream().filter(m -> PRISM_TYPE.contentEquals(((TypeElement)m.getAnnotationType().asElement()).getQualifiedName()));
    }

    private static <T> T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (clazz.isInstance(av.getValue())) {
            return clazz.cast(av.getValue());
        }
        return null;
    }

    private static <T> List<T> getArrayValues(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return List.of();
        }
        if (av.getValue() instanceof List) {
            ArrayList<T> result = new ArrayList<T>();
            for (AnnotationValue v : GeneratePrismPrism.getValueAsList(av)) {
                if (clazz.isInstance(v.getValue())) {
                    result.add(clazz.cast(v.getValue()));
                    continue;
                }
                return List.of();
            }
            return result;
        }
        return List.of();
    }

    private static List<AnnotationValue> getValueAsList(AnnotationValue av) {
        return (List)av.getValue();
    }
}

