/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.logging.slf4j;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import org.slf4j.helpers.Util;

final class SLF4JPlatformLogger
implements System.Logger {
    private final Logger slf4jLogger;

    SLF4JPlatformLogger(Logger logger) {
        this.slf4jLogger = Objects.requireNonNull(logger);
    }

    @Override
    public String getName() {
        return this.slf4jLogger.getName();
    }

    @Override
    public boolean isLoggable(System.Logger.Level platformLevel) {
        if (platformLevel == System.Logger.Level.ALL) {
            return true;
        }
        if (platformLevel == System.Logger.Level.OFF) {
            return false;
        }
        return this.isEnabledForLevel(this.toSLF4JLevel(platformLevel));
    }

    private boolean isEnabledForLevel(Level level) {
        switch (level) {
            case TRACE: {
                return this.slf4jLogger.isTraceEnabled();
            }
            case DEBUG: {
                return this.slf4jLogger.isDebugEnabled();
            }
            case INFO: {
                return this.slf4jLogger.isInfoEnabled();
            }
            case WARN: {
                return this.slf4jLogger.isWarnEnabled();
            }
            case ERROR: {
                return this.slf4jLogger.isErrorEnabled();
            }
        }
        throw new IllegalArgumentException("Level [" + level + "] not recognized.");
    }

    private Level toSLF4JLevel(System.Logger.Level platformLevel) {
        switch (platformLevel) {
            case TRACE: {
                return Level.TRACE;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARNING: {
                return Level.WARN;
            }
            case ERROR: {
                return Level.ERROR;
            }
        }
        this.reportUnknownLevel(platformLevel);
        return Level.TRACE;
    }

    @Override
    public void log(System.Logger.Level platformLevel, ResourceBundle bundle, String msg, Throwable thrown) {
        this.log(platformLevel, bundle, msg, thrown, (Object[])null);
    }

    @Override
    public void log(System.Logger.Level platformLevel, ResourceBundle bundle, String format, Object ... params) {
        this.log(platformLevel, bundle, format, null, params);
    }

    private void log(System.Logger.Level platformLevel, ResourceBundle bundle, String msg, Throwable thrown, Object ... params) {
        if (platformLevel == System.Logger.Level.OFF) {
            return;
        }
        if (platformLevel == System.Logger.Level.ALL) {
            this.performLog(Level.TRACE, bundle, msg, thrown, params);
            return;
        }
        this.performLog(this.toSLF4JLevel(platformLevel), bundle, msg, thrown, params);
    }

    private void performLog(Level slf4jLevel, ResourceBundle bundle, String msg, Throwable thrown, Object ... params) {
        switch (slf4jLevel) {
            case ERROR: {
                if (!this.slf4jLogger.isErrorEnabled()) break;
                this.slf4jLogger.error(this.message(bundle, msg, params), thrown);
                break;
            }
            case WARN: {
                if (!this.slf4jLogger.isWarnEnabled()) break;
                this.slf4jLogger.warn(this.message(bundle, msg, params), thrown);
                break;
            }
            case INFO: {
                if (!this.slf4jLogger.isInfoEnabled()) break;
                this.slf4jLogger.info(this.message(bundle, msg, params), thrown);
                break;
            }
            case DEBUG: {
                if (!this.slf4jLogger.isDebugEnabled()) break;
                this.slf4jLogger.debug(this.message(bundle, msg, params), thrown);
                break;
            }
            case TRACE: {
                if (!this.slf4jLogger.isTraceEnabled()) break;
                this.slf4jLogger.trace(this.message(bundle, msg, params), thrown);
            }
        }
    }

    private String message(ResourceBundle bundle, String msg, Object[] params) {
        String message = SLF4JPlatformLogger.resourceStringOrMessage(bundle, msg);
        if (params != null && params.length > 0) {
            message = MessageFormat.format(message, params);
        }
        return message;
    }

    private void reportUnknownLevel(System.Logger.Level platformLevel) {
        IllegalArgumentException iae = new IllegalArgumentException("Unknown log level [" + platformLevel + "]");
        Util.report((String)"Unsupported log level", (Throwable)iae);
    }

    private static String resourceStringOrMessage(ResourceBundle bundle, String msg) {
        if (bundle == null || msg == null) {
            return msg;
        }
        try {
            return bundle.getString(msg);
        }
        catch (MissingResourceException ex) {
            return msg;
        }
        catch (ClassCastException ex) {
            return bundle.getObject(msg).toString();
        }
    }
}

