/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.spi.internal;

import io.avaje.spi.internal.ModuleInfoReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public final class APContext {
    private static int jdkVersion;
    private static boolean previewEnabled;
    private static final ThreadLocal<Ctx> CTX;

    private APContext() {
    }

    public static void init(ProcessingEnvironment processingEnv) {
        CTX.set(new Ctx(processingEnv));
        jdkVersion = processingEnv.getSourceVersion().ordinal();
        previewEnabled = jdkVersion >= 13 && APContext.initPreviewEnabled(processingEnv);
    }

    private static boolean initPreviewEnabled(ProcessingEnvironment processingEnv) {
        try {
            return (Boolean)ProcessingEnvironment.class.getDeclaredMethod("isPreviewEnabled", new Class[0]).invoke((Object)processingEnv, new Object[0]);
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static void init(Ctx context, int jdkVersion, boolean preview) {
        CTX.set(context);
        APContext.jdkVersion = jdkVersion;
        previewEnabled = preview;
    }

    public static void clear() {
        CTX.remove();
    }

    public static int jdkVersion() {
        return jdkVersion;
    }

    public static boolean previewEnabled() {
        return previewEnabled;
    }

    private static Ctx getCtx() {
        Ctx ctx = CTX.get();
        if (ctx == null) {
            throw new IllegalStateException("APContext has not been initialized with APContext.init");
        }
        return CTX.get();
    }

    public static void logError(Element e, String msg, Object ... args) {
        APContext.messager().printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }

    public static void logError(String msg, Object ... args) {
        APContext.messager().printMessage(Diagnostic.Kind.ERROR, String.format(msg, args));
    }

    public static void logWarn(Element e, String msg, Object ... args) {
        APContext.messager().printMessage(Diagnostic.Kind.WARNING, String.format(msg, args), e);
    }

    public static void logWarn(String msg, Object ... args) {
        APContext.messager().printMessage(Diagnostic.Kind.WARNING, String.format(msg, args));
    }

    public static void logNote(Element e, String msg, Object ... args) {
        APContext.messager().printMessage(Diagnostic.Kind.NOTE, String.format(msg, args), e);
    }

    public static void logNote(String msg, Object ... args) {
        APContext.messager().printMessage(Diagnostic.Kind.NOTE, String.format(msg, args));
    }

    public static Set<? extends Element> elementsAnnotatedWith(RoundEnvironment round, String annotationFQN) {
        return Optional.ofNullable(APContext.typeElement(annotationFQN)).map(round::getElementsAnnotatedWith).orElse(Set.of());
    }

    public static JavaFileObject createSourceFile(CharSequence name, Element ... originatingElements) throws IOException {
        return APContext.filer().createSourceFile(name, originatingElements);
    }

    public static TypeElement typeElement(String name) {
        return APContext.elements().getTypeElement(name);
    }

    public static TypeElement asTypeElement(TypeMirror t) {
        return (TypeElement)APContext.types().asElement(t);
    }

    public static ProcessingEnvironment processingEnv() {
        return APContext.getCtx().processingEnv;
    }

    public static Filer filer() {
        return APContext.getCtx().filer;
    }

    public static Elements elements() {
        return APContext.getCtx().elementUtils;
    }

    public static Messager messager() {
        return APContext.getCtx().messager;
    }

    public static Types types() {
        return APContext.getCtx().typeUtils;
    }

    public static boolean isAssignable(String type, String superType) {
        return type.equals(superType) || APContext.isAssignable(APContext.typeElement(type), superType);
    }

    public static boolean isAssignable(TypeElement type, String superType) {
        return Optional.ofNullable(type).stream().flatMap(APContext::superTypes).anyMatch(superType::equals);
    }

    private static Stream<String> superTypes(TypeElement element) {
        Types types = APContext.types();
        return types.directSupertypes(element.asType()).stream().filter(type -> !type.toString().contains("java.lang.Object")).map(superType -> (TypeElement)types.asElement((TypeMirror)superType)).flatMap(e -> Stream.concat(APContext.superTypes(e), Stream.of(e))).map(Object::toString);
    }

    public static void setProjectModuleElement(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (APContext.getCtx().module == null) {
            APContext.getCtx().module = annotations.stream().map(roundEnv::getElementsAnnotatedWith).filter(Predicate.not(Collection::isEmpty)).findAny().map(s -> (Element)s.iterator().next()).map(APContext.elements()::getModuleOf).orElse(null);
        }
    }

    public static ModuleElement getProjectModuleElement() {
        return APContext.getCtx().module;
    }

    public static Optional<ModuleInfoReader> moduleInfoReader() {
        if (APContext.getCtx().moduleReader == null) {
            try {
                APContext.getCtx().moduleReader = new ModuleInfoReader();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Optional.ofNullable(APContext.getCtx().moduleReader);
    }

    public static BufferedReader getModuleInfoReader() throws IOException {
        String modulePath = APContext.isTestCompilation() ? "src/main/test" : "src/main/java";
        Path path = Path.of(APContext.filer().createResource(StandardLocation.CLASS_OUTPUT, "", UUID.randomUUID().toString(), new Element[0]).toUri());
        for (int i = 0; i < 5 && path != null && !path.resolve(modulePath).toFile().exists(); ++i, path = path.getParent()) {
        }
        Path moduleFile = path.resolve(modulePath + "/module-info.java");
        if (moduleFile.toFile().exists()) {
            return new BufferedReader(new InputStreamReader(moduleFile.toUri().toURL().openStream()));
        }
        Path sourcePath = Path.of(APContext.filer().getResource(StandardLocation.SOURCE_PATH, "", "module-info.java").toUri());
        return new BufferedReader(new InputStreamReader(sourcePath.toUri().toURL().openStream()));
    }

    public static Path getBuildResource(String path) throws IOException {
        String id = UUID.randomUUID().toString();
        String uri = APContext.filer().createResource(StandardLocation.CLASS_OUTPUT, "", path + id, new Element[0]).toUri().toString().replaceFirst(id, "").replaceFirst("/classes", "").replaceFirst("/classes/java/main", "");
        Path updatedPath = Path.of(URI.create(uri));
        if (path.contains("/")) {
            updatedPath.getParent().toFile().mkdirs();
        }
        return updatedPath;
    }

    public static boolean isTestCompilation() {
        return APContext.getCtx().isTestCompilation;
    }

    static {
        CTX = new ThreadLocal();
    }

    public static final class Ctx {
        private final ProcessingEnvironment processingEnv;
        private final Messager messager;
        private final Filer filer;
        private final Elements elementUtils;
        private final Types typeUtils;
        private ModuleElement module;
        private final boolean isTestCompilation;
        private ModuleInfoReader moduleReader;

        private Ctx(ProcessingEnvironment processingEnv) {
            boolean test;
            this.processingEnv = processingEnv;
            this.messager = processingEnv.getMessager();
            this.filer = processingEnv.getFiler();
            this.elementUtils = processingEnv.getElementUtils();
            this.typeUtils = processingEnv.getTypeUtils();
            try {
                test = this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", UUID.randomUUID().toString(), new Element[0]).toUri().toString().contains("test-classes");
            }
            catch (Exception e) {
                test = false;
            }
            this.isTestCompilation = test;
        }
    }
}

