/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.spi.internal;

import io.avaje.spi.internal.APContext;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;

final class Utils {
    Utils() {
    }

    static String fqnFromBinaryType(String binaryType) {
        TypeElement type = APContext.typeElement(binaryType.replace('$', '.'));
        if (type != null) {
            return type.getQualifiedName().toString();
        }
        type = APContext.typeElement(Utils.replaceDollar(binaryType));
        if (type != null) {
            return type.getQualifiedName().toString();
        }
        return binaryType;
    }

    static String replaceDollar(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char currChar = str.charAt(i);
            if (currChar == '$' && i > 0 && i < str.length() - 1) {
                char prevChar = str.charAt(i - 1);
                char nextChar = str.charAt(i + 1);
                if (Character.isLowerCase(prevChar) && Character.isUpperCase(nextChar)) {
                    sb.append('.');
                    continue;
                }
                sb.append(currChar);
                continue;
            }
            sb.append(currChar);
        }
        return sb.toString();
    }

    static void mergeServices(Map<String, Set<String>> newMap, Map<String, Set<String>> oldMap) {
        newMap.forEach((key, value) -> oldMap.merge((String)key, (Set<String>)value, (oldValue, newValue) -> {
            oldValue.addAll(newValue);
            return oldValue;
        }));
    }
}

