/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.spi.internal;

import io.avaje.spi.internal.APContext;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import javax.lang.model.element.ModuleElement;

final class PomPluginWriter {
    private static final String PLUGIN = "  <!-- generated by avaje spi service -->\n      <plugin>\n        <groupId>io.avaje</groupId>\n        <artifactId>avaje-provides-maven-plugin</artifactId>\n        <version>%s</version>\n        <executions>\n          <execution>\n            <!-- Will transform compiled module-info to add missing spi provides -->            <goals>\n              <goal>disable-apt-validation</goal>\n              <goal>add-module-spi</goal>\n            </goals>\n          </execution>\n        </executions>\n      </plugin>\n    ";

    PomPluginWriter() {
    }

    static void addPlugin2Pom() throws IOException {
        ModuleElement module = APContext.getProjectModuleElement();
        if (PomPluginWriter.disabledOrNotUsingModulePath(module)) {
            return;
        }
        Path pomPath = APContext.getBuildResource("").getParent().resolve("pom.xml");
        if (!pomPath.toFile().exists()) {
            return;
        }
        String pomContent = Files.readString(pomPath);
        if (pomContent.contains("avaje-provides-maven-plugin")) {
            return;
        }
        APContext.logNote("Adding avaje-provides-maven-plugin to pom", new Object[0]);
        int pluginsIndex = pomContent.indexOf("</plugins>");
        StringBuilder builder = new StringBuilder(pomContent);
        if (pluginsIndex != -1) {
            builder.insert(pluginsIndex, String.format(PLUGIN, "2.0"));
            Files.writeString(pomPath, (CharSequence)builder.toString(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        }
    }

    private static boolean disabledOrNotUsingModulePath(ModuleElement module) {
        return APContext.jdkVersion() < 24 || APContext.getOption("buildPlugin").map(Boolean::valueOf).orElse(true) == false || module == null || module.isUnnamed();
    }
}

