/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.spi.internal;

import io.avaje.spi.internal.APContext;
import io.avaje.spi.internal.ModuleInfoReader;
import io.avaje.spi.internal.ModuleReader;
import io.avaje.spi.internal.PomPluginWriter;
import io.avaje.spi.internal.ServicePrism;
import io.avaje.spi.internal.ServiceProviderPrism;
import io.avaje.spi.internal.Utils;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.StandardLocation;

@SupportedOptions(value={"buildPlugin"})
@SupportedAnnotationTypes(value={"io.avaje.spi.ServiceProvider", "io.avaje.inject.spi.Generated", "io.avaje.jsonb.spi.Generated", "io.avaje.http.api.Client", "io.avaje.http.api.Controller", "io.avaje.recordbuilder.Generated", "io.avaje.prism.GenerateAPContext", "io.avaje.validation.spi.Generated", "io.ebean.typequery.Generated", "javax.annotation.processing.Generated", "javax.annotation.processing.SupportedAnnotationTypes", "javax.annotation.processing.SupportedOptions", "javax.annotation.processing.SupportedSourceVersion"})
public class ServiceProcessor
extends AbstractProcessor {
    private static final String INJECT_EXTENSION = "io.avaje.inject.spi.InjectExtension";
    private static final Map<String, String> EXEMPT_SERVICES_MAP = Map.of("avaje-inject-generator", "io.avaje.inject.spi.InjectExtension", "avaje-validator-generator", "io.avaje.validation.spi.ValidationExtension", "avaje-jsonb-generator", "io.avaje.jsonb.spi.JsonbExtension");
    private static final Map<String, String> VALID_AVAJE_SPI = Map.of("io.avaje.config", "io.avaje.config.ConfigExtension", "io.avaje.inject.spi.AvajeModule", "io.avaje.inject.spi.InjectExtension", "io.avaje.inject.spi.InjectPlugin", "io.avaje.inject.spi.InjectExtension", "io.avaje.inject.spi.ModuleOrdering", "io.avaje.inject.spi.InjectExtension", "io.avaje.inject.spi.ConfigPropertyPlugin", "io.avaje.inject.spi.InjectExtension", "io.avaje.jsonb", "io.avaje.jsonb.spi.JsonbExtension", "io.avaje.validation", "io.avaje.validation.spi.ValidationExtension");
    private static final Set<String> EXEMPT_SERVICES = new HashSet<String>();
    private final Map<String, Set<String>> services = new ConcurrentHashMap<String, Set<String>>();
    private Elements elements;
    private Types types;
    private ModuleElement moduleElement;
    private Path servicesDirectory;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.elements = env.getElementUtils();
        this.types = env.getTypeUtils();
        APContext.init(env);
        Filer filer = env.getFiler();
        try {
            URI uri = filer.createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/spi-service-locator", new Element[0]).toUri();
            this.servicesDirectory = Path.of(uri).getParent();
            Path file = APContext.getBuildResource("avaje-processors.txt");
            StringBuilder addition = new StringBuilder();
            if (file.toFile().exists()) {
                String result = Stream.concat(Files.lines(file), Stream.of("avaje-spi-core")).distinct().collect(Collectors.joining("\n"));
                addition.append(result);
            } else {
                addition.append("avaje-spi-core");
            }
            Files.writeString(file, (CharSequence)addition.toString(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            PomPluginWriter.addPlugin2Pom();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> tes, RoundEnvironment roundEnv) {
        Set annotated = Optional.ofNullable(APContext.typeElement("io.avaje.spi.ServiceProvider")).map(roundEnv::getElementsAnnotatedWith).orElseGet(Set::of);
        this.processSpis(annotated);
        this.findModule(tes, roundEnv);
        if (roundEnv.processingOver()) {
            this.loadExemptService();
            this.write();
            this.validateCorrectAvajeServices();
            this.validateModule();
        }
        return false;
    }

    private void validateCorrectAvajeServices() {
        this.services.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("io.avaje") && !VALID_AVAJE_SPI.containsValue(e.getKey())).forEach(e -> {
            String key = (String)e.getKey();
            VALID_AVAJE_SPI.entrySet().stream().filter(spi -> key.contains((CharSequence)spi.getKey())).findAny().ifPresent(spi -> APContext.logError("Invalid spi entry META-INF/services/%s.\n All classes of this type should be registered in META-INF/services/%s", key, spi.getValue()));
        });
    }

    private void loadExemptService() {
        try (Stream<String> lines = Files.lines(APContext.getBuildResource("avaje-processors.txt"));){
            lines.filter(EXEMPT_SERVICES_MAP::containsKey).forEach(p -> EXEMPT_SERVICES.add(EXEMPT_SERVICES_MAP.get(p)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void processSpis(Collection<? extends Element> annotated) {
        for (TypeElement type : ElementFilter.typesIn(annotated)) {
            this.validate(type);
            List<TypeElement> contracts = this.getServiceInterfaces(type);
            if (contracts.isEmpty()) {
                APContext.logError(type, "Service Providers must implement an SPI interface", new Object[0]);
            }
            for (TypeElement contract : contracts) {
                String cn = this.elements.getBinaryName(contract).toString();
                Set v = this.services.computeIfAbsent(cn, k -> new TreeSet());
                v.add(this.elements.getBinaryName(type).toString());
            }
        }
    }

    private void validate(TypeElement type) {
        boolean noPublicConstructor;
        Set<Modifier> mods = type.getModifiers();
        if (!mods.contains((Object)Modifier.PUBLIC) || type.getEnclosingElement().getKind() == ElementKind.CLASS && !mods.contains((Object)Modifier.STATIC)) {
            APContext.logError(type, "A Service Provider must be a public class or a public static nested class", new Object[0]);
        }
        if (noPublicConstructor = ElementFilter.constructorsIn(type.getEnclosedElements()).stream().filter(e -> e.getParameters().isEmpty()).filter(e -> e.getModifiers().contains((Object)Modifier.PUBLIC)).findAny().isEmpty()) {
            APContext.logError(type, "A Service Provider must have a public no-args constructor", new Object[0]);
        }
    }

    private void write() {
        Map<String, Set<String>> allServices = this.loadMetaInfServices(this.servicesDirectory);
        allServices.forEach((key, value) -> this.services.computeIfPresent((String)key, (k, v) -> {
            v.addAll(value);
            return v;
        }));
        for (Map.Entry<String, Set<String>> e : this.services.entrySet()) {
            String contract = e.getKey();
            if (EXEMPT_SERVICES.contains(contract)) continue;
            APContext.logNote("Writing META-INF/services/%s", contract);
            try {
                OutputStream file = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/" + contract, new Element[0]).openOutputStream();
                try (PrintWriter pw = new PrintWriter(new OutputStreamWriter(file, StandardCharsets.UTF_8));){
                    for (String value2 : e.getValue()) {
                        pw.println(value2);
                    }
                }
                finally {
                    if (file == null) continue;
                    file.close();
                }
            }
            catch (IOException x) {
                APContext.logError("Failed to write service definition files: %s", x);
            }
        }
        Utils.mergeServices(allServices, this.services);
    }

    private Map<String, Set<String>> loadMetaInfServices(Path servicesDirectory) {
        HashMap<String, Set<String>> allServices = new HashMap<String, Set<String>>();
        if (servicesDirectory == null) {
            return allServices;
        }
        try (Stream<Path> servicePaths = Files.walk(servicesDirectory, 1, new FileVisitOption[0]).skip(1L);){
            Iterable pathIterable = servicePaths::iterator;
            for (Path servicePath : pathIterable) {
                String contract = Utils.fqnFromBinaryType(servicePath.getFileName().toString());
                if (APContext.typeElement(contract) == null) continue;
                Set impls = allServices.computeIfAbsent(contract, k -> new TreeSet());
                try {
                    InputStream file = servicePath.toUri().toURL().openStream();
                    try (BufferedReader buffer = new BufferedReader(new InputStreamReader(file));){
                        String line;
                        while ((line = buffer.readLine()) != null) {
                            line.replaceAll("\\s", "").replace(',', '\n').lines().forEach(impls::add);
                        }
                    }
                    finally {
                        if (file == null) continue;
                        file.close();
                    }
                }
                catch (FileNotFoundException | NoSuchFileException file) {
                }
                catch (IOException x) {
                    APContext.logError("Failed to load existing service definition file. SPI: " + contract + " exception: " + String.valueOf(x), new Object[0]);
                }
            }
        }
        catch (NoSuchFileException e) {
            APContext.logNote("No service definition file found", new Object[0]);
        }
        catch (Exception e) {
            APContext.logError("Failed to load service definition file" + String.valueOf(e), new Object[0]);
        }
        return allServices;
    }

    private List<TypeElement> getServiceInterfaces(TypeElement type) {
        boolean hasInterfaces;
        ArrayList<TypeElement> typeElementList = new ArrayList<TypeElement>();
        List<TypeMirror> spis = ServiceProviderPrism.getInstanceOn(type).value();
        List<? extends TypeMirror> interfaces = type.getInterfaces();
        boolean hasBaseClass = type.getSuperclass().getKind() != TypeKind.NONE && !this.isObject(type.getSuperclass());
        boolean bl = hasInterfaces = !interfaces.isEmpty();
        if (spis.isEmpty()) {
            if (this.checkSPI(type.asType(), typeElementList)) {
                return typeElementList;
            }
            if (hasBaseClass ^ hasInterfaces) {
                if (hasBaseClass) {
                    typeElementList.add(APContext.asTypeElement(type.getSuperclass()));
                } else {
                    typeElementList.add(APContext.asTypeElement(type.getInterfaces().get(0)));
                }
            } else {
                APContext.logError(type, "SPI type was not specified, and could not be inferred.", new Object[0]);
            }
            return typeElementList;
        }
        for (TypeMirror spiMirror : spis) {
            if (!hasInterfaces && !hasBaseClass || !this.isAssignable2Interface(type, spiMirror)) {
                APContext.logError(type, "Service Provider does not extend %s", spiMirror);
                continue;
            }
            if (spiMirror instanceof DeclaredType) {
                typeElementList.add(APContext.asTypeElement(spiMirror));
                continue;
            }
            APContext.logError(type, "Invalid type specified as the Service Provider Interface", new Object[0]);
        }
        return typeElementList;
    }

    private boolean checkSPI(TypeMirror typeMirror, List<TypeElement> typeElementList) {
        TypeElement type = APContext.asTypeElement(typeMirror);
        if (type == null) {
            return false;
        }
        if (ServicePrism.isPresent(type)) {
            typeElementList.add(type);
            return true;
        }
        ArrayList<? extends TypeMirror> supers = new ArrayList<TypeMirror>();
        supers.add(type.getSuperclass());
        supers.addAll(type.getInterfaces());
        for (TypeMirror typeMirror2 : supers) {
            if (!this.checkSPI(typeMirror2, typeElementList)) continue;
            return true;
        }
        return false;
    }

    private boolean isObject(TypeMirror t) {
        if (t instanceof DeclaredType) {
            return "java.lang.Object".equals(APContext.asTypeElement(t).getQualifiedName().toString());
        }
        return false;
    }

    private boolean isAssignable2Interface(Element type, TypeMirror superType) {
        return Optional.ofNullable(type).stream().flatMap(this::superTypes).anyMatch(superType.toString()::equals);
    }

    private Stream<String> superTypes(Element element) {
        return this.types.directSupertypes(element.asType()).stream().filter(type -> !type.toString().contains("java.lang.Object")).map(superType -> (TypeElement)this.types.asElement((TypeMirror)superType)).flatMap(e -> Stream.concat(this.superTypes((Element)e), Stream.of(e))).map(Object::toString);
    }

    ModuleElement findModule(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.moduleElement == null) {
            this.moduleElement = annotations.stream().map(roundEnv::getElementsAnnotatedWith).flatMap(Collection::stream).findAny().map(this::getModuleElement).orElseThrow();
        }
        return this.moduleElement;
    }

    ModuleElement getModuleElement(Element e) {
        if (e == null || e instanceof ModuleElement) {
            return (ModuleElement)e;
        }
        return this.getModuleElement(e.getEnclosingElement());
    }

    void validateModule() {
        if (this.moduleElement != null && !this.moduleElement.isUnnamed()) {
            ModuleReader moduleReader = new ModuleReader(this.services);
            APContext.moduleInfoReader().ifPresent(reader -> {
                moduleReader.read((ModuleInfoReader)reader);
                if (moduleReader.staticWarning()) {
                    APContext.logError(this.moduleElement, "`requires io.avaje.spi` should be `requires static io.avaje.spi;`", new Object[0]);
                }
                if (moduleReader.coreWarning()) {
                    APContext.logWarn(this.moduleElement, "io.avaje.spi.core should not be used directly", new Object[0]);
                }
                if (!ServiceProcessor.buildPluginAvailable() && !APContext.isTestCompilation()) {
                    this.logModuleError(moduleReader);
                }
            });
        }
    }

    private void logModuleError(ModuleReader moduleReader) {
        moduleReader.missing().forEach((k, v) -> {
            v.removeIf(this::isNotSameModule);
            if (!v.isEmpty()) {
                String contract = this.services.keySet().stream().filter(s -> s.replace('$', '.').equals(k.replace('$', '.'))).findAny().orElseThrow();
                String missingImpls = this.services.get(contract).stream().filter(Predicate.not(this::isNotSameModule)).map(Utils::fqnFromBinaryType).collect(Collectors.joining(", "));
                APContext.logError(this.moduleElement, "Missing `provides %s with %s;`", Utils.fqnFromBinaryType(contract), missingImpls);
            }
        });
    }

    private boolean isNotSameModule(String type) {
        TypeElement element = APContext.typeElement(type);
        return element == null || !this.elements.getModuleOf(element).getSimpleName().contentEquals(this.moduleElement.getSimpleName());
    }

    private static boolean buildPluginAvailable() {
        return ServiceProcessor.resource("avaje-plugin-exists.txt");
    }

    private static boolean resource(String relativeName) {
        try {
            return APContext.getBuildResource(relativeName).toFile().exists();
        }
        catch (Exception e) {
            return false;
        }
    }
}

