/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.generator;

import io.avaje.validation.generator.APContext;
import io.avaje.validation.generator.Append;
import io.avaje.validation.generator.Constants;
import io.avaje.validation.generator.ElementAnnotationContainer;
import io.avaje.validation.generator.UType;
import io.avaje.validation.generator.Util;
import java.util.Map;

final class AdapterHelper {
    private final Append writer;
    private final ElementAnnotationContainer elementAnnotations;
    private final String indent;
    private final String type;
    private final UType mainType;
    private final UType genericType;
    private final boolean classLevel;
    private final boolean crossParam;
    private boolean usePrimitiveValidation;
    private String recursiveType;

    AdapterHelper(Append writer, ElementAnnotationContainer elementAnnotations, String indent) {
        this(writer, elementAnnotations, indent, "Object", null, false, false);
    }

    AdapterHelper(Append writer, ElementAnnotationContainer elementAnnotations, String indent, String type, UType mainType, boolean classLevel) {
        this(writer, elementAnnotations, indent, type, mainType, classLevel, false);
    }

    AdapterHelper(Append writer, ElementAnnotationContainer elementAnnotations, String indent, String type, UType mainType, boolean classLevel, boolean crossParam) {
        this.writer = writer;
        this.elementAnnotations = elementAnnotations;
        this.indent = indent;
        this.type = type;
        this.mainType = mainType;
        this.genericType = elementAnnotations.genericType();
        this.classLevel = classLevel;
        this.crossParam = crossParam;
    }

    AdapterHelper usePrimitiveValidation(boolean usePrimitiveValidation) {
        this.usePrimitiveValidation = usePrimitiveValidation;
        return this;
    }

    void write() {
        Map<UType, String> typeUse1 = this.elementAnnotations.typeUse1();
        Map<UType, String> typeUse2 = this.elementAnnotations.typeUse2();
        boolean hasValid = this.elementAnnotations.hasValid();
        this.writeFirst(this.crossParam ? this.elementAnnotations.crossParam() : this.elementAnnotations.annotations());
        if (this.crossParam) {
            return;
        }
        if (this.usePrimitiveValidation) {
            this.writer.eol().append("%s    .primitive()", this.indent);
            return;
        }
        if (!typeUse1.isEmpty() && APContext.isAssignable(this.genericType.mainType(), "java.lang.Iterable")) {
            this.writer.eol().append("%s    .list()", this.indent);
            this.writeTypeUse(this.genericType.param0(), typeUse1);
        } else if (this.isTopTypeIterable()) {
            this.writer.eol().append("%s    .list()", this.indent);
            if (hasValid) {
                if (this.mainType.param0().fullWithoutAnnotations().equals(this.recursiveType)) {
                    this.writer.eol().append("%s    .andThenMulti(this)", this.indent, this.mainType.param0().shortType());
                } else {
                    this.writer.eol().append("%s    .andThenMulti(ctx.adapter(%s.class))", this.indent, this.mainType.param0().shortType());
                }
            }
        } else if (this.isMapType(typeUse1, typeUse2)) {
            this.writer.eol().append("%s    .mapKeys()", this.indent);
            this.writeTypeUse(this.genericType.param0(), typeUse1);
            this.writer.eol().append("%s    .mapValues()", this.indent);
            this.writeTypeUse(this.genericType.param1(), typeUse2, false);
        } else if (hasValid && this.genericType.mainType().contains("[]")) {
            this.writer.eol().append("%s    .array()", this.indent);
            if (this.genericType.mainType().replace("[]", "").equals(this.recursiveType)) {
                this.writer.eol().append("%s    .andThenMulti(this)", this.indent);
            } else {
                this.writer.eol().append("%s    .andThenMulti(ctx.adapter(%s.class))", this.indent, this.mainType.shortWithoutAnnotations().replace("[]", ""));
            }
        } else if (hasValid) {
            if (!this.classLevel) {
                if (this.genericType.mainType().equals(this.recursiveType)) {
                    this.writer.eol().append("%s    .andThen(this)", this.indent);
                } else {
                    this.writer.eol().append("%s    .andThen(ctx.adapter(%s.class))", this.indent, this.genericType.shortWithoutAnnotations());
                }
            }
        } else if (this.genericType.mainType().contains("java.util.Optional")) {
            this.writer.eol().append("%s    .optional()", this.indent);
        }
    }

    private void writeFirst(Map<UType, String> annotations) {
        boolean first = true;
        for (Map.Entry<UType, String> a : annotations.entrySet()) {
            if (first) {
                this.writer.append("%sctx.<%s>adapter(%s.class, %s)", this.indent, this.type, a.getKey().shortWithoutAnnotations(), a.getValue());
                first = false;
                continue;
            }
            this.writer.eol().append("%s    .andThen(ctx.adapter(%s.class,%s))", this.indent, a.getKey().shortWithoutAnnotations(), a.getValue());
        }
        if (annotations.isEmpty()) {
            this.writer.append("%sctx.<%s>noop()", this.indent, this.type);
        }
    }

    private boolean isMapType(Map<UType, String> typeUse1, Map<UType, String> typeUse2) {
        return (!typeUse1.isEmpty() || !typeUse2.isEmpty()) && "java.util.Map".equals(this.genericType.mainType());
    }

    private boolean isTopTypeIterable() {
        return this.mainType != null && APContext.isAssignable(this.mainType.mainType(), "java.lang.Iterable");
    }

    private void writeTypeUse(UType uType, Map<UType, String> typeUse12) {
        this.writeTypeUse(uType, typeUse12, true);
    }

    private void writeTypeUse(UType uType, Map<UType, String> typeUseMap, boolean keys) {
        for (Map.Entry<UType, String> a : typeUseMap.entrySet()) {
            if (Constants.VALID_ANNOTATIONS.contains(a.getKey().mainType())) continue;
            String k = a.getKey().shortType();
            String v = a.getValue();
            this.writer.eol().append("%s    .andThenMulti(ctx.adapter(%s.class,%s))", this.indent, k, v);
        }
        if (!Util.isBasicType(uType.fullWithoutAnnotations())) {
            if (typeUseMap.keySet().stream().map(UType::mainType).anyMatch(Constants.VALID_ANNOTATIONS::contains)) {
                UType typeUse = keys ? this.genericType.param0() : this.genericType.param1();
                this.writer.eol().append("%s    .andThenMulti(ctx.adapter(%s.class))", this.indent, typeUse.shortWithoutAnnotations());
            }
        }
    }

    void withEnclosingType(UType recursive) {
        this.recursiveType = recursive.fullWithoutAnnotations();
    }
}

