/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.generator;

import io.avaje.validation.generator.APContext;
import io.avaje.validation.generator.ProcessingContext;
import io.avaje.validation.generator.Util;
import javax.lang.model.element.TypeElement;

final class AdapterName {
    final String shortName;
    final String adapterPackage;
    final String fullName;

    AdapterName(TypeElement origin) {
        String originPackage = APContext.elements().getPackageOf(origin).toString();
        String name = this.shortName(origin);
        this.shortName = name.substring(0, name.length() - 1);
        this.adapterPackage = "".equals(originPackage) ? "valid" : (ProcessingContext.isImported(origin) ? originPackage + ".valid" : originPackage);
        this.fullName = this.adapterPackage + "." + this.shortName + "ValidationAdapter";
    }

    private String shortName(TypeElement origin) {
        StringBuilder sb = new StringBuilder();
        if (origin.getNestingKind().isNested()) {
            sb.append(this.shortName((TypeElement)origin.getEnclosingElement()));
        }
        return sb.append(Util.shortName(origin.getSimpleName().toString())).append("$").toString();
    }

    String shortName() {
        return this.shortName;
    }

    String adapterPackage() {
        return this.adapterPackage;
    }

    String fullName() {
        return this.fullName;
    }
}

