/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.generator;

import io.avaje.validation.generator.APContext;
import io.avaje.validation.generator.AnnotationFactoryPrism;
import io.avaje.validation.generator.ComponentMetaData;
import io.avaje.validation.generator.MetaDataPrism;
import io.avaje.validation.generator.ProcessingContext;
import io.avaje.validation.generator.ValidFactoryPrism;
import java.util.Objects;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

final class ComponentReader {
    private final ComponentMetaData componentMetaData;

    ComponentReader(ComponentMetaData metaData) {
        this.componentMetaData = metaData;
    }

    void read() {
        ProcessingContext.readExistingMetaInfServices().stream().map(APContext::typeElement).filter(Objects::nonNull).filter(t -> "io.avaje.validation.spi.GeneratedComponent".equals(t.getSuperclass().toString())).findFirst().ifPresent(moduleType -> {
            this.componentMetaData.setFullName(moduleType.getQualifiedName().toString());
            this.readMetaData((TypeElement)moduleType);
        });
    }

    private void readMetaData(TypeElement moduleType) {
        for (AnnotationMirror annotationMirror : moduleType.getAnnotationMirrors()) {
            MetaDataPrism metaData = MetaDataPrism.getInstance(annotationMirror);
            ValidFactoryPrism metaDataFactory = ValidFactoryPrism.getInstance(annotationMirror);
            AnnotationFactoryPrism metaDataAnnotationFactory = AnnotationFactoryPrism.getInstance(annotationMirror);
            if (metaData != null) {
                metaData.value().stream().map(TypeMirror::toString).forEach(this.componentMetaData::add);
                continue;
            }
            if (metaDataFactory != null) {
                metaDataFactory.value().stream().map(TypeMirror::toString).forEach(this.componentMetaData::add);
                continue;
            }
            if (metaDataAnnotationFactory == null) continue;
            metaDataAnnotationFactory.value().stream().map(APContext::asTypeElement).forEach(this.componentMetaData::addAnnotationAdapter);
        }
    }
}

