/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.generator;

import io.avaje.validation.generator.AnnotationUtil;
import io.avaje.validation.generator.Append;
import io.avaje.validation.generator.BeanReader;
import io.avaje.validation.generator.ConstraintPrism;
import io.avaje.validation.generator.UType;
import io.avaje.validation.generator.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;

final class ContraintReader
implements BeanReader {
    private final TypeElement beanType;
    private final String type;
    private final Set<String> importTypes = new TreeSet<String>();
    private final Map<UType, String> annotations;

    ContraintReader(TypeElement element) {
        this.beanType = element;
        this.type = element.getQualifiedName().toString();
        this.importTypes.add(this.type);
        this.importTypes.add("java.util.List");
        this.importTypes.add("java.util.Set");
        this.importTypes.add("java.util.Map");
        this.importTypes.add("io.avaje.validation.adapter.ConstraintAdapter");
        this.importTypes.add("io.avaje.validation.adapter.ValidationAdapter");
        this.importTypes.add("io.avaje.validation.adapter.ValidationRequest");
        this.importTypes.add("io.avaje.validation.adapter.ValidationContext.AdapterCreateRequest");
        this.importTypes.add("io.avaje.validation.spi.Generated");
        this.annotations = element.getAnnotationMirrors().stream().filter(a -> ConstraintPrism.isPresent(a.getAnnotationType().asElement())).flatMap(m -> this.expand((AnnotationMirror)m, (List<AnnotationMirror>)new ArrayList<AnnotationMirror>()).stream()).collect(Collectors.toMap(a -> UType.parse(a.getAnnotationType()), a -> AnnotationUtil.annotationAttributeMap(a, element)));
    }

    private List<AnnotationMirror> expand(AnnotationMirror m, List<AnnotationMirror> mirrors) {
        mirrors.add(m);
        m.getAnnotationType().getAnnotationMirrors().stream().filter(a -> ConstraintPrism.isPresent(a.getAnnotationType().asElement())).forEach(mirrors::add);
        return mirrors;
    }

    @Override
    public int genericTypeParamsCount() {
        return 0;
    }

    @Override
    public String contraintTarget() {
        return Util.shortName(this.type);
    }

    public String toString() {
        return this.beanType.toString();
    }

    @Override
    public String shortName() {
        return "Object";
    }

    @Override
    public TypeElement getBeanType() {
        return this.beanType;
    }

    @Override
    public boolean nonAccessibleField() {
        return false;
    }

    @Override
    public boolean hasValidationAnnotation() {
        return false;
    }

    @Override
    public void read() {
    }

    private Set<String> importTypes() {
        this.importTypes.add(this.type);
        this.annotations.keySet().forEach(t -> this.importTypes.addAll(t.importTypes()));
        return this.importTypes;
    }

    @Override
    public void writeImports(Append writer, String adapterPackage) {
        for (String importType : this.importTypes()) {
            if (!Util.validImportType(importType, adapterPackage)) continue;
            writer.append("import %s;", importType).eol();
        }
        writer.eol();
    }

    @Override
    public void cascadeTypes(Set<String> types) {
    }

    @Override
    public void writeFields(Append writer) {
        writer.append("  private final ValidationAdapter<Object> adapter;").eol().eol();
    }

    @Override
    public void writeConstructor(Append writer) {
        writer.append("    final var message = req.message().template();\n    final var ctx = req.ctx();\n    final var groups = req.groups();\n    this.adapter =\n");
        boolean first = true;
        for (Map.Entry<UType, String> a : new ArrayList<Map.Entry<UType, String>>(this.annotations.entrySet())) {
            if (first) {
                writer.append("        ctx.adapter(%s.class, groups, message, %s)", a.getKey().shortWithoutAnnotations(), a.getValue());
                first = false;
                continue;
            }
            writer.eol().append("            .andThen(ctx.adapter(%s.class, groups, message, %s))", a.getKey().shortWithoutAnnotations(), a.getValue());
        }
        writer.append(";").eol();
    }

    @Override
    public void writeValidatorMethod(Append writer) {
        writer.eol();
        writer.append("  @Override\n  public boolean validate(Object value, ValidationRequest req, String propertyName) {\n\n    return adapter.validate(value, req, propertyName);\n  }\n").eol();
    }
}

