/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.generator;

import io.avaje.validation.generator.APContext;
import io.avaje.validation.generator.AnnotationUtil;
import io.avaje.validation.generator.ConstraintPrism;
import io.avaje.validation.generator.CrossParamConstraintPrism;
import io.avaje.validation.generator.PrimitiveUtil;
import io.avaje.validation.generator.UType;
import io.avaje.validation.generator.Util;
import io.avaje.validation.generator.ValidPrism;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;

record ElementAnnotationContainer(UType genericType, boolean hasValid, Map<UType, String> annotations, Map<UType, String> typeUse1, Map<UType, String> typeUse2, Map<UType, String> crossParam) {
    static ElementAnnotationContainer create(Element element) {
        UType uType;
        boolean hasValid = ValidPrism.isPresent(element);
        HashMap<UType, String> crossParam = new HashMap<UType, String>();
        if (element instanceof ExecutableElement) {
            ExecutableElement executableElement = (ExecutableElement)element;
            uType = UType.parse(executableElement.getReturnType());
        } else {
            uType = UType.parse(element.asType());
        }
        Map<UType, String> typeUse1 = Optional.ofNullable(uType.param0()).map(UType::annotations).stream().flatMap(Collection::stream).filter(ElementAnnotationContainer::hasMetaConstraintAnnotation).collect(Collectors.toMap(a -> UType.parse(a.getAnnotationType()), a -> AnnotationUtil.annotationAttributeMap(a, element)));
        Map<UType, String> typeUse2 = Optional.ofNullable(uType.param1()).map(UType::annotations).stream().flatMap(Collection::stream).filter(ElementAnnotationContainer::hasMetaConstraintAnnotation).collect(Collectors.toMap(a -> UType.parse(a.getAnnotationType()), a -> AnnotationUtil.annotationAttributeMap(a, element)));
        Map<UType, String> annotations = element.getAnnotationMirrors().stream().filter(m -> !ValidPrism.isInstance(m)).filter(ElementAnnotationContainer::hasMetaConstraintAnnotation).map(a -> {
            if (CrossParamConstraintPrism.isPresent(a.getAnnotationType().asElement())) {
                crossParam.put(UType.parse(a.getAnnotationType()), AnnotationUtil.annotationAttributeMap(a, element));
                return null;
            }
            return a;
        }).filter(Objects::nonNull).collect(Collectors.toMap(a -> UType.parse(a.getAnnotationType()), a -> AnnotationUtil.annotationAttributeMap(a, element)));
        if (Util.isNonNullable(element)) {
            UType nonNull = UType.parse(APContext.typeElement("org.jspecify.annotations.NonNull").asType());
            annotations.put(nonNull, "Map.of(\"message\",\"{avaje.NotNull.message}\")");
        }
        return new ElementAnnotationContainer(uType, hasValid, annotations, typeUse1, typeUse2, crossParam);
    }

    static boolean hasMetaConstraintAnnotation(AnnotationMirror m) {
        return ElementAnnotationContainer.hasMetaConstraintAnnotation(m.getAnnotationType().asElement()) || ValidPrism.isInstance(m);
    }

    static boolean hasMetaConstraintAnnotation(Element element) {
        return ConstraintPrism.isPresent(element);
    }

    static ElementAnnotationContainer create(VariableElement varElement) {
        UType uType = UType.parse(varElement.asType());
        Map<UType, String> annotations = uType.annotations().stream().filter(m -> !ValidPrism.isInstance(m)).filter(ElementAnnotationContainer::hasMetaConstraintAnnotation).collect(Collectors.toMap(a -> UType.parse(a.getAnnotationType()), a -> AnnotationUtil.annotationAttributeMap(a, varElement)));
        Map<UType, String> typeUse1 = Optional.ofNullable(uType.param0()).map(UType::annotations).stream().flatMap(Collection::stream).filter(ElementAnnotationContainer::hasMetaConstraintAnnotation).collect(Collectors.toMap(a -> UType.parse(a.getAnnotationType()), a -> AnnotationUtil.annotationAttributeMap(a, varElement)));
        Map<UType, String> typeUse2 = Optional.ofNullable(uType.param1()).map(UType::annotations).stream().flatMap(Collection::stream).filter(ElementAnnotationContainer::hasMetaConstraintAnnotation).collect(Collectors.toMap(a -> UType.parse(a.getAnnotationType()), a -> AnnotationUtil.annotationAttributeMap(a, varElement)));
        boolean hasValid = uType.annotations().stream().anyMatch(ValidPrism::isInstance);
        if (Util.isNonNullable(varElement)) {
            UType nonNull = UType.parse(APContext.typeElement("org.jspecify.annotations.NonNull").asType());
            annotations.put(nonNull, "Map.of(\"message\",\"{avaje.NotNull.message}\")");
        }
        return new ElementAnnotationContainer(uType, hasValid, annotations, typeUse1, typeUse2, Map.of());
    }

    public void addImports(Set<String> importTypes) {
        importTypes.addAll(this.genericType.importTypes());
        this.annotations.keySet().forEach(t -> importTypes.addAll(t.importTypes()));
        this.typeUse1.keySet().forEach(t -> importTypes.addAll(t.importTypes()));
        this.typeUse2.keySet().forEach(t -> importTypes.addAll(t.importTypes()));
    }

    boolean isEmpty() {
        return this.annotations.isEmpty() && this.typeUse1.isEmpty() && this.typeUse2.isEmpty();
    }

    boolean supportsPrimitiveValidation() {
        for (UType validationAnnotation : this.annotations.keySet()) {
            ConstraintPrism.getOptionalOn(APContext.typeElement(validationAnnotation.full())).ifPresent(p -> {
                if (p.unboxPrimitives().booleanValue()) {
                    validationAnnotation.shortType().transform(PrimitiveUtil::addPrimitiveValidationAnnotation);
                }
            });
            if (PrimitiveUtil.isPrimitiveValidationAnnotations(validationAnnotation.shortType())) continue;
            return false;
        }
        return true;
    }
}

