/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.generator;

import io.avaje.validation.generator.APContext;
import io.avaje.validation.generator.ModuleInfoReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.Name;
import javax.lang.model.util.Elements;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

final class ProcessingContext {
    private static final ThreadLocal<Ctx> CTX = new ThreadLocal();

    private ProcessingContext() {
    }

    static void init(ProcessingEnvironment processingEnv) {
        CTX.set(new Ctx(processingEnv));
        APContext.init(processingEnv);
    }

    static FileObject createMetaInfWriterFor(String interfaceType) throws IOException {
        return APContext.filer().createResource(StandardLocation.CLASS_OUTPUT, "", interfaceType, new Element[0]);
    }

    static String diAnnotation() {
        return ProcessingContext.CTX.get().diAnnotation;
    }

    static boolean isImported(Element element) {
        Name moduleName = APContext.getProjectModuleElement().getQualifiedName();
        return !APContext.elements().getModuleOf(element).getQualifiedName().contentEquals(moduleName);
    }

    static void validateModule() {
        ModuleElement module = APContext.getProjectModuleElement();
        if (module != null && !module.isUnnamed()) {
            boolean injectPresent = ProcessingContext.CTX.get().injectPresent;
            boolean warnHttp = ProcessingContext.CTX.get().warnHttp;
            try (BufferedReader reader = APContext.getModuleInfoReader();){
                boolean noInjectPlugin;
                ModuleInfoReader moduleInfo = new ModuleInfoReader(module, reader);
                moduleInfo.validateServices("io.avaje.validation.spi.ValidationExtension", ProcessingContext.CTX.get().serviceSet);
                boolean buildPluginAvailable = ProcessingContext.buildPluginAvailable();
                Set requireSet = moduleInfo.requires().stream().map(ModuleInfoReader.Requires::getDependency).map(m -> m.getQualifiedName().toString()).collect(Collectors.toSet());
                boolean noHttpPlugin = injectPresent && (!buildPluginAvailable || !requireSet.contains("io.avaje.http.api")) && warnHttp && !moduleInfo.containsOnModulePath("io.avaje.validation.http");
                boolean bl = noInjectPlugin = noHttpPlugin && injectPresent && (!buildPluginAvailable || !requireSet.contains("io.avaje.validation")) && !moduleInfo.containsOnModulePath("io.avaje.validation.plugin");
                if (noHttpPlugin) {
                    APContext.logWarn(module, "`requires io.avaje.validation.http` must be explicity added or else avaje-inject may fail to detect the default http validator, validator, and method AOP validator", new Object[0]);
                } else if (noInjectPlugin) {
                    APContext.logWarn(module, "`requires io.avaje.validation.plugin` must be explicity added or else avaje-inject may fail to detect the default validator and method AOP validator", new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean buildPluginAvailable() {
        try {
            return APContext.getBuildResource("avaje-plugin-exists.txt").toFile().exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    static Set<String> readExistingMetaInfServices() {
        Set<String> services = ProcessingContext.CTX.get().serviceSet;
        try (InputStream file = APContext.filer().getResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/io.avaje.validation.spi.ValidationExtension").toUri().toURL().openStream();
             BufferedReader buffer = new BufferedReader(new InputStreamReader(file));){
            String line;
            while ((line = buffer.readLine()) != null) {
                line.replaceAll("\\s", "").replace(",", "\n").lines().forEach(services::add);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return services;
    }

    static void clear() {
        CTX.remove();
        APContext.clear();
    }

    public static void addValidatorSpi(String spi) {
        ProcessingContext.CTX.get().serviceSet.add(spi);
    }

    private static final class Ctx {
        private final String diAnnotation;
        private final boolean warnHttp;
        private final boolean injectPresent;
        private final Set<String> serviceSet = new TreeSet<String>();

        Ctx(ProcessingEnvironment env) {
            boolean jakarta;
            Elements elements = env.getElementUtils();
            this.injectPresent = elements.getTypeElement("io.avaje.inject.Component") != null;
            this.warnHttp = elements.getTypeElement("io.avaje.http.api.Controller") != null;
            boolean bl = jakarta = elements.getTypeElement("jakarta.inject.Singleton") != null;
            this.diAnnotation = this.injectPresent ? "io.avaje.inject.Component" : (jakarta ? "jakarta.inject.Singleton" : "javax.inject.Singleton");
        }
    }
}

