/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.generator;

import io.avaje.validation.generator.APContext;
import io.avaje.validation.generator.AdapterName;
import io.avaje.validation.generator.Append;
import io.avaje.validation.generator.BeanReader;
import io.avaje.validation.generator.ContraintReader;
import io.avaje.validation.generator.Util;
import java.io.IOException;
import java.io.Writer;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;

final class SimpleAdapterWriter {
    private final BeanReader beanReader;
    private final String adapterShortName;
    private final String adapterPackage;
    private final String adapterFullName;
    private final int genericParamsCount;
    private final boolean isContraint;
    private Append writer;

    SimpleAdapterWriter(BeanReader beanReader) {
        this.beanReader = beanReader;
        AdapterName adapterName = new AdapterName(beanReader.getBeanType());
        this.adapterShortName = adapterName.shortName();
        this.adapterPackage = adapterName.adapterPackage();
        this.adapterFullName = adapterName.fullName();
        this.genericParamsCount = beanReader.genericTypeParamsCount();
        this.isContraint = beanReader instanceof ContraintReader;
    }

    String fullName() {
        return this.adapterFullName;
    }

    private Writer createFileWriter() throws IOException {
        JavaFileObject jfo = APContext.createSourceFile(this.adapterFullName, new Element[0]);
        return jfo.openWriter();
    }

    void write() throws IOException {
        this.writer = new Append(this.createFileWriter());
        this.writePackage();
        this.writeImports();
        this.writeClassStart();
        this.writeFields();
        this.writeConstructor();
        this.writeValidation();
        this.writeClassEnd();
        this.writer.close();
    }

    private void writeConstructor() {
        int i;
        if (this.isContraint) {
            this.writer.append("  public %sValidationAdapter(AdapterCreateRequest req", this.adapterShortName);
        } else {
            this.writer.append("  public %sValidationAdapter(ValidationContext ctx", this.adapterShortName);
            for (i = 0; i < this.genericParamsCount; ++i) {
                this.writer.append(", Type param%d", i);
            }
        }
        this.writer.append(") {", this.adapterShortName).eol();
        this.beanReader.writeConstructor(this.writer);
        this.writer.append("  }").eol();
        if (this.genericParamsCount > 0) {
            this.writer.eol();
            this.writer.append("  /**").eol();
            this.writer.append("   * Construct using Object for generic type parameters.").eol();
            this.writer.append("   */").eol();
            this.writer.append("  public %sValidationAdapter(ValidationContext ctx) {", this.adapterShortName).eol();
            this.writer.append("    this(ctx");
            for (i = 0; i < this.genericParamsCount; ++i) {
                this.writer.append(", Object.class");
            }
            this.writer.append(");").eol();
            this.writer.append("  }").eol();
        }
    }

    private void writeValidation() {
        this.beanReader.writeValidatorMethod(this.writer);
    }

    private void writeClassEnd() {
        this.writer.append("}").eol();
    }

    private void writeClassStart() {
        this.writer.append("@Generated(\"avaje-validator-generator\")").eol();
        if (this.isContraint) {
            this.writer.append("@ConstraintAdapter(%s.class)", this.beanReader.contraintTarget()).eol();
        }
        this.writer.append("public final %sclass %sValidationAdapter implements ValidationAdapter<%s> ", Util.valhalla(), this.adapterShortName, this.beanReader.shortName());
        this.writer.append("{").eol().eol();
    }

    private void writeFields() {
        this.beanReader.writeFields(this.writer);
    }

    private void writeImports() {
        this.beanReader.writeImports(this.writer, this.adapterPackage);
    }

    private void writePackage() {
        this.writer.append("package %s;", this.adapterPackage).eol().eol();
    }
}

