/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.generator;

import io.avaje.validation.generator.APContext;
import io.avaje.validation.generator.FieldReader;
import io.avaje.validation.generator.MethodReader;
import io.avaje.validation.generator.Util;
import io.avaje.validation.generator.ValidPrism;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

final class TypeReader {
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private final List<FieldReader> allFields = new ArrayList<FieldReader>();
    private final Map<String, FieldReader> allFieldMap = new HashMap<String, FieldReader>();
    private final Map<String, MethodReader> allGetterMethods = new LinkedHashMap<String, MethodReader>();
    private final Map<String, MethodReader> maybeGetterMethods = new LinkedHashMap<String, MethodReader>();
    private final TypeElement baseType;
    private final boolean hasValidAnnotation;
    private final Set<String> seenFields = new HashSet<String>();
    private boolean nonAccessibleField;
    private final List<String> genericTypeParams;
    private final Map<String, VariableElement> mixInFields = new HashMap<String, VariableElement>();
    private final Map<String, ExecutableElement> mixInMethods = new HashMap<String, ExecutableElement>();
    private FieldReader mixinClassAdapter;

    TypeReader(TypeElement baseType, TypeElement mixInType) {
        this.baseType = baseType;
        this.hasValidAnnotation = Util.isValid(baseType);
        this.genericTypeParams = this.initTypeParams(baseType);
        if (mixInType != null) {
            this.mixinClassAdapter = new FieldReader(baseType, mixInType, this.genericTypeParams);
            mixInType.getEnclosedElements().forEach(e -> {
                ExecutableElement ex;
                if (e instanceof VariableElement) {
                    VariableElement v = (VariableElement)e;
                    this.mixInFields.put(v.getSimpleName().toString(), v);
                } else if (e instanceof ExecutableElement && (ex = (ExecutableElement)e).getParameters().isEmpty()) {
                    this.mixInMethods.put(ex.getSimpleName().toString(), ex);
                }
            });
        }
    }

    void read(TypeElement type) {
        FieldReader classAdapter;
        ArrayList<FieldReader> localFields = new ArrayList<FieldReader>();
        for (Element element : type.getEnclosedElements()) {
            switch (element.getKind()) {
                case FIELD: {
                    this.readField(element, localFields);
                    break;
                }
                case METHOD: {
                    this.readMethod(element, type, localFields);
                    break;
                }
            }
        }
        FieldReader fieldReader = classAdapter = this.mixinClassAdapter != null ? this.mixinClassAdapter : new FieldReader((Element)type, this.genericTypeParams, true);
        if (classAdapter.hasConstraints()) {
            localFields.add(classAdapter);
        }
        for (FieldReader localField : localFields) {
            this.allFields.add(localField);
            this.allFieldMap.put(localField.fieldName(), localField);
        }
    }

    private void readField(Element element, List<FieldReader> localFields) {
        Element mixInField = this.mixInFields.get(element.getSimpleName().toString());
        if (mixInField != null && APContext.types().isSameType(mixInField.asType(), element.asType())) {
            HashSet<Modifier> mixinModifiers = new HashSet<Modifier>(mixInField.getModifiers());
            HashSet<Modifier> modifiers = new HashSet<Modifier>(mixInField.getModifiers());
            Arrays.stream(Modifier.values()).filter(m -> m != Modifier.PRIVATE || m != Modifier.PROTECTED || m != Modifier.PUBLIC).forEach(m -> {
                modifiers.remove(m);
                mixinModifiers.remove(m);
            });
            if (!modifiers.equals(mixinModifiers)) {
                APContext.logError(mixInField, "mixIn fields must have the same modifiers as the target class", new Object[0]);
            }
            element = mixInField;
        }
        if (this.includeField(element) || Util.isNonNullable(element)) {
            this.seenFields.add(element.toString());
            FieldReader reader = new FieldReader(element, this.genericTypeParams);
            if (reader.hasConstraints() || ValidPrism.isPresent(element)) {
                localFields.add(reader);
            }
        }
    }

    private List<String> initTypeParams(TypeElement beanType) {
        if (beanType.getTypeParameters().isEmpty()) {
            return Collections.emptyList();
        }
        return beanType.getTypeParameters().stream().map(Object::toString).collect(Collectors.toList());
    }

    int genericTypeParamsCount() {
        return this.genericTypeParams.size();
    }

    private boolean includeField(Element element) {
        return !element.getModifiers().contains((Object)Modifier.TRANSIENT) && (element.getAnnotationMirrors().stream().filter(m -> !m.toString().contains("@java")).anyMatch(m -> !m.toString().contains("lombok")) || element.asType().toString().contains("@"));
    }

    private void readMethod(Element element, TypeElement type, List<FieldReader> localFields) {
        ExecutableElement methodElement = (ExecutableElement)element;
        ExecutableElement mixinMethod = this.mixInMethods.get(methodElement.getSimpleName().toString());
        if (methodElement.getParameters().isEmpty() && mixinMethod != null && APContext.types().isSameType(mixinMethod.asType(), element.asType())) {
            HashSet<Modifier> mixinModifiers = new HashSet<Modifier>(mixinMethod.getModifiers());
            HashSet<Modifier> modifiers = new HashSet<Modifier>(mixinMethod.getModifiers());
            Arrays.stream(Modifier.values()).filter(m -> m != Modifier.PRIVATE || m != Modifier.PROTECTED || m != Modifier.PUBLIC).forEach(m -> {
                modifiers.remove(m);
                mixinModifiers.remove(m);
            });
            if (!modifiers.equals(mixinModifiers)) {
                APContext.logError(mixinMethod, "mixIn methods must have the same access modifiers as the target class", new Object[0]);
            }
            methodElement = mixinMethod;
        }
        if (Util.isPublic(methodElement)) {
            List<? extends VariableElement> parameters = methodElement.getParameters();
            String methodKey = methodElement.getSimpleName().toString();
            MethodReader methodReader = new MethodReader(methodElement, type).read();
            if (parameters.isEmpty()) {
                this.maybeGetterMethods.putIfAbsent(methodKey, methodReader);
                this.allGetterMethods.put(methodKey.toLowerCase(), methodReader);
            }
            if (this.includeField(methodElement) && methodElement.getParameters().isEmpty() && this.seenFields.add(methodElement.getSimpleName().toString())) {
                FieldReader reader = new FieldReader(methodElement, this.genericTypeParams);
                localFields.add(reader);
                reader.getterMethod(new MethodReader(methodElement, type));
            }
        }
    }

    private void matchFieldsToGetter() {
        for (FieldReader field : this.allFields) {
            if (field.isClassLvl()) continue;
            this.matchFieldToGetter(field);
        }
    }

    private void matchFieldToGetter(FieldReader field) {
        if (!(this.matchFieldToGetter2(field, false) || this.matchFieldToGetter2(field, true) || field.isPublicField())) {
            this.nonAccessibleField = true;
            if (this.hasValidAnnotation) {
                APContext.logError("Non accessible field " + String.valueOf(this.baseType) + " " + field.fieldName() + " with no matching getter?", new Object[0]);
            } else {
                APContext.logNote("Non accessible field " + String.valueOf(this.baseType) + " " + field.fieldName(), new Object[0]);
            }
        }
    }

    private boolean matchFieldToGetter2(FieldReader field, boolean loose) {
        String name = field.fieldName();
        MethodReader getter = this.getterLookup(name, loose);
        if (getter != null) {
            field.getterMethod(getter);
            return true;
        }
        getter = this.getterLookup(this.getterName(name), loose);
        if (getter != null) {
            field.getterMethod(getter);
            return true;
        }
        getter = this.getterLookup(this.isGetterName(name), loose);
        if (getter != null) {
            field.getterMethod(getter);
            return true;
        }
        if (field.typeObjectBooleanWithIsPrefix() && (getter = this.getterLookup(this.getterName(name.substring(2)), loose)) != null) {
            field.getterMethod(getter);
            return true;
        }
        return false;
    }

    private MethodReader getterLookup(String name, boolean loose) {
        if (!loose) {
            return this.maybeGetterMethods.get(name);
        }
        return this.allGetterMethods.get(name.toLowerCase());
    }

    private String getterName(String name) {
        return "get" + Util.initCap(name);
    }

    private String isGetterName(String name) {
        return "is" + Util.initCap(name);
    }

    boolean nonAccessibleField() {
        return this.nonAccessibleField;
    }

    List<FieldReader> allFields() {
        return this.allFields;
    }

    void process() {
        TypeElement superElement;
        String base = this.baseType.getQualifiedName().toString();
        if (!base.contains("<")) {
            this.read(this.baseType);
        }
        if ((superElement = this.superOf(this.baseType)) != null) {
            this.addSuperType(superElement);
        }
        this.processCompleted();
    }

    void processCompleted() {
        this.matchFieldsToGetter();
    }

    private void addSuperType(TypeElement element) {
        String type = element.getQualifiedName().toString();
        if (!JAVA_LANG_OBJECT.equals(type) && !type.contains("<")) {
            this.read(element);
            this.addSuperType(this.superOf(element));
        }
    }

    private TypeElement superOf(TypeElement element) {
        return APContext.asTypeElement(element.getSuperclass());
    }
}

